/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class UpdateShopItem {
    private final TARDIS plugin;
    private final String prefix;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();

    public UpdateShopItem(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterRecord(HashMap<String, Object> data, HashMap<String, Object> where) {
        PreparedStatement ps = null;
        StringBuilder sbu = new StringBuilder();
        StringBuilder sbw = new StringBuilder();
        data.forEach((key, value) -> sbu.append((String)key).append(" = ?,"));
        where.forEach((key, value) -> {
            sbw.append((String)key).append(" = ");
            if (value instanceof String || value instanceof UUID) {
                sbw.append("'").append(value).append("' AND ");
            } else {
                sbw.append(value).append(" AND ");
            }
        });
        where.clear();
        String updates = sbu.substring(0, sbu.length() - 1);
        String wheres = sbw.substring(0, sbw.length() - 5);
        String query = "UPDATE " + this.prefix + "items SET " + updates + " WHERE " + wheres;
        try {
            ps = this.connection.prepareStatement(query);
            int s = 1;
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                    ps.setString(s, entry.getValue().toString());
                } else if (entry.getValue() instanceof Double) {
                    ps.setDouble(s, (Double)entry.getValue());
                }
                ++s;
            }
            data.clear();
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for items table! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items table! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(String location, int id) {
        PreparedStatement ps = null;
        String query = "UPDATE " + this.prefix + "items SET location = ? WHERE item_id = ?";
        try {
            ps = this.connection.prepareStatement(query);
            ps.setString(1, location);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for items table! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items table! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCost(double cost, int id) {
        PreparedStatement ps = null;
        String query = "UPDATE " + this.prefix + "items SET cost = ? WHERE item_id = ?";
        try {
            ps = this.connection.prepareStatement(query);
            ps.setDouble(1, cost);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for items table! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items table! " + e.getMessage());
            }
        }
    }
}

