/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.SelectedSlot;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMap;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMapData;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISARSMapListener
extends TARDISARSMethods
implements Listener {
    private final HashMap<UUID, String> selectedLocation = new HashMap();
    private final HashMap<UUID, SelectedSlot> selectedSlot = new HashMap();

    public TARDISARSMapListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onARSMapClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TARDISARSMap)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
        this.ids.put(playerUUID, this.getTardisId(uuid.toString()));
        int slot = event.getRawSlot();
        if (slot != 10 && slot != 45 && !this.hasLoadedMap.contains(playerUUID)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_LOAD");
            return;
        }
        if (slot < 0 || slot > 53) {
            return;
        }
        switch (slot) {
            case 1: 
            case 9: 
            case 11: 
            case 19: {
                this.moveMap(playerUUID, view, slot);
                break;
            }
            case 10: {
                this.loadMap(view, playerUUID);
                break;
            }
            case 45: {
                this.close(player);
                break;
            }
            case 47: {
                this.findPlayer(player, view);
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                if (this.map_data.containsKey(playerUUID)) {
                    this.switchLevel(view, slot, playerUUID);
                    TARDISARSMapData md = (TARDISARSMapData)this.map_data.get(playerUUID);
                    this.setMap(md.getY(), md.getE(), md.getS(), playerUUID, view);
                    this.setLore(view, slot, null);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
                break;
            }
            case 46: {
                if (this.map_data.containsKey(playerUUID)) {
                    if (!this.selectedLocation.containsKey(playerUUID)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_SELECT");
                        break;
                    }
                    if (this.selectedLocation.get(playerUUID).equals("TERRACOTTA")) {
                        this.setLore(view, slot, this.plugin.getLanguage().getString("TRANSMAT_RENDER"));
                        break;
                    }
                    Location tp_loc = this.getRoomLocation(player);
                    if (tp_loc == null) break;
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        player.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        player.teleport(tp_loc);
                    }, 10L);
                    this.close(player);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
                break;
            }
            default: {
                if (this.map_data.containsKey(playerUUID)) {
                    ItemMeta im;
                    String dn;
                    TARDISARSMapData md = (TARDISARSMapData)this.map_data.get(playerUUID);
                    ItemStack is = view.getItem(slot);
                    if (is == null || (dn = ComponentUtils.stripColour((im = is.getItemMeta()).displayName())).equals("Empty slot")) break;
                    this.selectedLocation.put(playerUUID, is.getType().toString());
                    int col = slot / 9 + md.getS();
                    int row = slot % 9 - (4 - md.getE());
                    this.selectedSlot.put(playerUUID, new SelectedSlot(md.getY(), row, col));
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
            }
        }
    }

    private void findPlayer(Player player, InventoryView view) {
        if (this.map_data.containsKey(player.getUniqueId())) {
            UUID playerUUID = player.getUniqueId();
            int id = (Integer)this.ids.get(playerUUID);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                int pos = tardis.getTIPS();
                int tx = 0;
                int tz = 0;
                if (pos != -1) {
                    TARDISInteriorPostioning tips = new TARDISInteriorPostioning(this.plugin);
                    TARDISTIPSData coords = tips.getTIPSData(pos);
                    tx = coords.getCentreX();
                    tz = coords.getCentreZ();
                }
                Location loc = player.getLocation();
                int px = loc.getBlockX();
                int pz = loc.getBlockZ();
                int col = (int)(4.0 + Math.floor((double)(px - tx) / 16.0));
                int row = (int)(4.0 + Math.floor((double)(pz - tz) / 16.0));
                if (col < 0 || col > 8 || row < 0 || row > 8) {
                    this.setLore(view, 47, this.plugin.getLanguage().getString("ARS_MAP_OUTSIDE"));
                    return;
                }
                int east = this.getOffset(col);
                int south = this.getOffset(row);
                int py = loc.getBlockY();
                int level = 28;
                if (py >= 48 && py < 64) {
                    level = 27;
                }
                if (py >= 80 && py < 96) {
                    level = 29;
                }
                this.switchLevel(view, level, playerUUID);
                TARDISARSMapData md = (TARDISARSMapData)this.map_data.get(playerUUID);
                md.setY(level - 27);
                md.setE(east);
                md.setS(south);
                this.setMap(level - 27, east, south, playerUUID, view);
                this.setLore(view, level, null);
                this.map_data.put(playerUUID, md);
                int slot = (row - south) * 9 + 4 + (col - east);
                ItemStack is = view.getItem(slot);
                ItemStack sub = ItemStack.of((Material)Material.SPECTRAL_ARROW);
                ItemMeta im = is.getItemMeta();
                im.lore(List.of(Component.text((String)this.plugin.getLanguage().getString("ARS_MAP_HERE", "You are here!"))));
                sub.setItemMeta(im);
                view.setItem(slot, sub);
            }
        } else {
            this.setLore(view, 47, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
        }
    }

    private Location getRoomLocation(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.map_data.containsKey(uuid)) {
            UUID playerUUID = player.getUniqueId();
            int id = (Integer)this.ids.get(playerUUID);
            String room = this.selectedLocation.get(playerUUID);
            if (this.consoleBlocks.contains(room)) {
                TARDISDoorLocation idl = TARDISDoorListener.getDoor(1, id);
                return idl.getL();
            }
            SelectedSlot selected = this.selectedSlot.get(uuid);
            if (selected != null) {
                TARDISARSSlot a = new TARDISARSSlot();
                a.setChunk(this.plugin.getLocationUtils().getTARDISChunk(id));
                a.setY(selected.level());
                a.setX(selected.row());
                a.setZ(selected.column());
                return new Location(a.getChunk().getWorld(), (double)a.getX(), (double)a.getY(), (double)a.getZ()).add(3.5, 5.0, 8.5);
            }
        }
        return null;
    }

    private int getOffset(double d) {
        int offset = 2;
        if (d >= 6.0) {
            offset = 4;
        }
        if (d == 5.0) {
            offset = 3;
        }
        if (d == 3.0) {
            offset = 1;
        }
        if (d <= 2.0) {
            offset = 0;
        }
        return offset;
    }

    @Override
    public void close(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.hasLoadedMap.remove(playerUUID);
        this.map_data.remove(playerUUID);
        this.ids.remove(playerUUID);
        this.selectedLocation.remove(playerUUID);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
    }
}

