/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIConfiguration;
import me.eccentric_nz.TARDIS.custommodels.GUIKeyPreferences;
import me.eccentric_nz.TARDIS.custommodels.GUIPlayerPreferences;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Features;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.skins.CharacterSkins;
import me.eccentric_nz.TARDIS.skins.CompanionSkins;
import me.eccentric_nz.TARDIS.skins.CyberSkins;
import me.eccentric_nz.TARDIS.skins.MonsterSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;

public class ComponentCommand {
    private final TARDIS plugin;
    private final String template = "{\n   \"model\": {\n     \"type\": \"minecraft:select\",\n     \"property\": \"component\",\n     \"component\": \"minecraft:custom_name\",\n     \"fallback\": {\n       \"type\": \"minecraft:model\",\n       \"model\": \"minecraft:block/%s\"\n     },\n     \"cases\": [\n       {\n         \"when\": {\n           \"text\": \"\",\n           \"extra\": [\n               \"%s\"\n           ]\n         },\n         \"model\": {\n           \"type\": \"minecraft:model\",\n           \"model\": \"tardis:item/gui/room/%s\"\n         }\n       }\n     ]\n   }\n }\n";
    private Gson gson;

    public ComponentCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void writeARS() {
        try {
            File dir = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "component_models");
            if (!dir.exists() && dir.mkdir()) {
                dir.setWritable(true);
                dir.setExecutable(true);
            }
            for (TARDISARS ars : TARDISARS.values()) {
                if (ars.getMaterial().isEmpty()) continue;
                String material = ars.getMaterial().toLowerCase(Locale.ROOT);
                String json = String.format("{\n   \"model\": {\n     \"type\": \"minecraft:select\",\n     \"property\": \"component\",\n     \"component\": \"minecraft:custom_name\",\n     \"fallback\": {\n       \"type\": \"minecraft:model\",\n       \"model\": \"minecraft:block/%s\"\n     },\n     \"cases\": [\n       {\n         \"when\": {\n           \"text\": \"\",\n           \"extra\": [\n               \"%s\"\n           ]\n         },\n         \"model\": {\n           \"type\": \"minecraft:model\",\n           \"model\": \"tardis:item/gui/room/%s\"\n         }\n       }\n     ]\n   }\n }\n", material, ars.getDescriptiveName(), ars.toString().toLowerCase(Locale.ROOT));
                File file = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + "processed" + File.separator + material + ".json");
                BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));
                bw.write(json);
                bw.close();
            }
            this.plugin.debug("Component model writing complete.");
        }
        catch (IOException e) {
            this.plugin.debug(e.getMessage());
        }
    }

    public void writeKey() {
        JsonObject base = new JsonObject();
        base.addProperty("type", "minecraft:select");
        base.addProperty("property", "component");
        base.addProperty("component", "minecraft:custom_model_data");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:item/gold_nugget");
        base.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        int i = 1;
        for (GUIKeyPreferences kk : GUIKeyPreferences.values()) {
            if (kk.getSlot() >= 18) continue;
            String lowercaseName = kk.toString().toLowerCase(Locale.ROOT);
            JsonObject case_cmd = this.getCase(100 + i, lowercaseName, "key");
            cases.add((JsonElement)case_cmd);
            ++i;
        }
        base.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "processed" + File.separator + "gold_nugget.json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)base, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.debug("File write error for gold_nugget");
            this.plugin.debug(e.getMessage());
        }
    }

    public void writeRepeater() {
        JsonObject case_on;
        JsonObject case_off;
        String lowercaseName;
        JsonObject base = new JsonObject();
        base.addProperty("type", "minecraft:select");
        base.addProperty("property", "component");
        base.addProperty("component", "minecraft:custom_model_data");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:item/repeater");
        base.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        int i = 1;
        for (GUIPlayerPreferences gUIPlayerPreferences : GUIPlayerPreferences.values()) {
            if (gUIPlayerPreferences.getMaterial() != Material.REPEATER) continue;
            lowercaseName = gUIPlayerPreferences.toString().toLowerCase(Locale.ROOT);
            case_off = this.getCase(100 + i, lowercaseName + "_off", "gui/repeater");
            cases.add((JsonElement)case_off);
            case_on = this.getCase(200 + i, lowercaseName + "_on", "gui/repeater");
            cases.add((JsonElement)case_on);
            ++i;
        }
        for (Enum enum_ : GUIConfiguration.values()) {
            if (((GUIConfiguration)enum_).getMaterial() != Material.REPEATER) continue;
            lowercaseName = enum_.toString().toLowerCase(Locale.ROOT);
            case_off = this.getCase(100 + i, lowercaseName + "_off", "gui/repeater");
            cases.add((JsonElement)case_off);
            case_on = this.getCase(200 + i, lowercaseName + "_on", "gui/repeater");
            cases.add((JsonElement)case_on);
            ++i;
        }
        base.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "processed" + File.separator + "repeater.json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)base, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.debug("File write error for repeater");
            this.plugin.debug(e.getMessage());
        }
    }

    private JsonObject getCase(int i, String name, String path) {
        JsonObject object = new JsonObject();
        JsonObject when = new JsonObject();
        JsonArray floats = new JsonArray();
        floats.add((Number)i);
        when.add("floats", (JsonElement)floats);
        object.add("when", (JsonElement)when);
        JsonObject model = new JsonObject();
        model.addProperty("type", "minecraft:model");
        model.addProperty("model", "tardis:item/" + path + "/" + name);
        object.add("model", (JsonElement)model);
        return object;
    }

    public void writeExtra(CommandSender sender) {
        NamespacedKey key;
        String material;
        block104: for (Skin skin : CharacterSkins.CHARACTERS) {
            material = "leather";
            switch (skin.name()) {
                case "Bannakaffalatta": {
                    material = "nether_wart";
                    key = Features.BANNAKAFFALATTA_SPIKES.getKey();
                    break;
                }
                case "Brigadier Lethbridge-Stewart": {
                    key = Features.BRIGADIER_LETHBRIDGE_STEWART_HAT.getKey();
                    break;
                }
                case "Dalek Sec": {
                    material = "mangrove_propagule";
                    key = Features.DALEK_SEC_TENTACLES.getKey();
                    break;
                }
                case "Hath": {
                    material = "pufferfish";
                    key = Features.HATH_FEATURES.getKey();
                    break;
                }
                case "Impossible Astronaut": {
                    material = "orange_stained_glass_pane";
                    key = Features.IMPOSSIBLE_ASTRONAUT_PACK.getKey();
                    break;
                }
                case "Jenny Flint": {
                    this.writeFile(sender, "leather", Features.JENNY_FLINT_KATANA.getKey().getKey(), "Katana");
                    continue block104;
                }
                case "Judoon": {
                    material = "yellow_dye";
                    key = Features.JUDOON_SNOUT.getKey();
                    break;
                }
                case "Ood": {
                    material = "rotten_flesh";
                    key = Features.OOD_FEATURES.getKey();
                    break;
                }
                case "Strax": {
                    material = "potato";
                    key = Features.STRAX_EARS.getKey();
                    break;
                }
                default: {
                    continue block104;
                }
            }
            if (key != null) {
                this.writeFile((CommandSender)this.plugin.getConsole(), material, key.getKey(), skin.name());
                continue;
            }
            this.plugin.debug("null key for " + skin.name());
        }
        block105: for (Skin skin : CompanionSkins.COMPANIONS) {
            material = "leather";
            switch (skin.name()) {
                case "Ace": {
                    key = Features.ACE_PONYTAIL.getKey();
                    break;
                }
                case "Jo Grant": {
                    key = Features.JO_GRANT_HAIR.getKey();
                    break;
                }
                case "Martha Jones": {
                    key = Features.MARTHA_JONES_HAIR.getKey();
                    break;
                }
                case "Tegan": {
                    key = Features.TEGAN_HAT.getKey();
                    break;
                }
                default: {
                    continue block105;
                }
            }
            if (key != null) {
                this.writeFile((CommandSender)this.plugin.getConsole(), material, key.getKey(), skin.name());
                continue;
            }
            this.plugin.debug("null key for " + skin.name());
        }
        block106: for (Skin skin : CyberSkins.VARIANTS) {
            material = "leather";
            switch (skin.name()) {
                case "Cyberman": {
                    material = "iron_ingot";
                    key = Features.CYBERMAN_FEATURES.getKey();
                    this.writeFile(sender, material, CybermanVariant.CYBER_WEAPON.getKey().getKey(), "Cyber Weapon");
                    break;
                }
                case "Wooden Cyberman": {
                    material = "spruce_button";
                    key = Features.WOOD_CYBERMAN_FEATURES.getKey();
                    this.writeFile(sender, material, CybermanVariant.WOOD_CYBER_WEAPON.getKey().getKey(), "Wood Cyber Weapon");
                    break;
                }
                case "Black Cyberman": {
                    material = "iron_ingot";
                    key = Features.BLACK_CYBERMAN_FEATURES.getKey();
                    break;
                }
                case "Invasion Cyberman": {
                    material = "iron_ingot";
                    key = Features.CYBERMAN_INVASION_FEATURES.getKey();
                    this.writeFile(sender, material, CybermanVariant.CYBERMAN_INVASION_ARM.getKey().getKey(), "Cyber Arm");
                    break;
                }
                case "Rise of the Cyberman": 
                case "Cyber Lord": 
                case "Moonbase Cyberman": {
                    material = "iron_ingot";
                    key = switch (skin.name()) {
                        case "Rise of the Cyberman" -> Features.CYBERMAN_RISE_FEATURES.getKey();
                        case "Moonbase Cyberman" -> Features.CYBERMAN_MOONBASE_FEATURES.getKey();
                        default -> Features.CYBER_LORD_FEATURES.getKey();
                    };
                    this.writeFile(sender, material, CybermanVariant.CYBERMAN_INVASION_ARM.getKey().getKey(), "Cyber Arm");
                    break;
                }
                case "Tenth Planet Cyberman": {
                    material = "iron_ingot";
                    key = Features.CYBERMAN_TENTH_PLANET_FEATURES.getKey();
                    break;
                }
                case "Earthshock Cyberman": {
                    material = "iron_ingot";
                    key = Features.CYBERMAN_EARTHSHOCK_FEATURES.getKey();
                    break;
                }
                case "Cybershade": {
                    key = Features.CYBERSHADE_EARS.getKey();
                    break;
                }
                default: {
                    continue block106;
                }
            }
            if (key != null) {
                this.writeFile((CommandSender)this.plugin.getConsole(), material, key.getKey(), skin.name());
                continue;
            }
            this.plugin.debug("null key for " + skin.name());
        }
        block107: for (Skin skin : MonsterSkins.MONSTERS) {
            material = "leather";
            switch (skin.name()) {
                case "Angel of Liberty": {
                    key = Features.ANGEL_OF_LIBERTY_CROWN.getKey();
                    this.writeFile(sender, "torch", Features.ANGEL_OF_LIBERTY_TORCH.getKey().getKey(), "Liberty Torch");
                    break;
                }
                case "Empty Child": {
                    material = "sugar";
                    key = Features.EMPTY_CHILD_MASK.getKey();
                    break;
                }
                case "Ice Warrior": {
                    material = "snowball";
                    key = Features.ICE_WARRIOR_CREST.getKey();
                    break;
                }
                case "Mire": {
                    material = "netherite_scrap";
                    key = Features.MIRE_HELMET.getKey();
                    this.writeFile(sender, "netherite_scrap", MireVariant.MIRE_LEFT_ARM.getKey().getKey(), skin.name() + " Left Arm");
                    this.writeFile(sender, "netherite_scrap", MireVariant.MIRE_RIGHT_ARM.getKey().getKey(), skin.name() + " Right Arm");
                    break;
                }
                case "Omega": {
                    key = Features.OMEGA_FRILL.getKey();
                    break;
                }
                case "Racnoss": {
                    key = Features.RACNOSS_FEATURES.getKey();
                    break;
                }
                case "Scarecrow": {
                    material = "wheat";
                    key = Features.SCARECROW_EARS.getKey();
                    break;
                }
                case "Sea Devil": {
                    material = "kelp";
                    key = Features.SEA_DEVIL_EARS.getKey();
                    break;
                }
                case "Silence": {
                    material = "end_stone";
                    key = Features.SILENCE_SIDE_HEAD.getKey();
                    break;
                }
                case "Silurian": {
                    material = "feather";
                    key = Features.SILURIAN_CREST.getKey();
                    break;
                }
                case "Slitheen": {
                    material = "turtle_egg";
                    key = Features.SLITHEEN_HEAD.getKey();
                    this.writeFile(sender, "turtle_egg", SlitheenVariant.SLITHEEN_CLAW_LEFT.getKey().getKey(), skin.name() + " Left Claw");
                    this.writeFile(sender, "turtle_egg", SlitheenVariant.SLITHEEN_CLAW_RIGHT.getKey().getKey(), skin.name() + " Right Claw");
                    break;
                }
                case "Sontaran": {
                    material = "potato";
                    key = Features.SONTARAN_EARS.getKey();
                    break;
                }
                case "Sutekh": {
                    key = Features.SUTEKH_FEATURES.getKey();
                    break;
                }
                case "Sycorax": {
                    key = Features.SYCORAX_CAPE.getKey();
                    break;
                }
                case "The Beast": {
                    key = Features.THE_BEAST_HORNS.getKey();
                    break;
                }
                case "Vampire of Venice": {
                    material = "cod";
                    key = Features.VAMPIRE_OF_VENICE_FAN.getKey();
                    break;
                }
                case "Weeping Angel": {
                    material = "brick";
                    key = Features.WEEPING_ANGEL_WINGS.getKey();
                    break;
                }
                case "Zygon": {
                    material = "painting";
                    key = Features.ZYGON_CREST.getKey();
                    break;
                }
                default: {
                    continue block107;
                }
            }
            if (key != null) {
                this.writeFile((CommandSender)this.plugin.getConsole(), material, key.getKey(), skin.name());
                continue;
            }
            this.plugin.debug("null key for " + skin.name());
        }
    }

    private void writeFile(CommandSender sender, String material, String key, String name) {
        JsonObject model;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        String filename = material + "_" + key;
        JsonObject select = new JsonObject();
        select.addProperty("type", "minecraft:select");
        select.addProperty("property", "component");
        select.addProperty("component", "minecraft:custom_name");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:item/" + material);
        select.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        JsonObject matcher = new JsonObject();
        JsonObject when = new JsonObject();
        when.addProperty("text", "");
        JsonArray extra = new JsonArray();
        extra.add(name);
        when.add("extra", (JsonElement)extra);
        matcher.add("when", (JsonElement)when);
        try {
            String path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + key + ".json";
            sender.sendMessage(path);
            File child = new File(path);
            JsonReader reader = new JsonReader((Reader)new FileReader(child));
            JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            model = root.get("model").getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            model = new JsonObject();
            model.addProperty("type", "minecraft:model");
            model.addProperty("model", "tardis:item/" + key);
        }
        matcher.add("model", (JsonElement)model);
        cases.add((JsonElement)matcher);
        select.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + "processed" + File.separator + filename + ".json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson((JsonElement)select, (Appendable)writer);
        }
        catch (IOException e) {
            sender.sendMessage("File write error for " + filename);
            sender.sendMessage(e.getMessage());
        }
    }
}

