/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISGameModeCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"SURVIVAL", (Object)"s", (Object)"CREATIVE", (Object)"c", (Object)"ADVENTURE", (Object)"a", (Object)"SPECTATOR", (Object)"sp");

    public TARDISGameModeCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisgamemode")) {
            if (label.equalsIgnoreCase("tgms")) {
                return this.setPlayerGameMode(sender, args, GameMode.SURVIVAL);
            }
            if (label.equalsIgnoreCase("tgmc")) {
                return this.setPlayerGameMode(sender, args, GameMode.CREATIVE);
            }
            if (label.equalsIgnoreCase("tgma")) {
                return this.setPlayerGameMode(sender, args, GameMode.ADVENTURE);
            }
            if (label.equalsIgnoreCase("tgmsp")) {
                return this.setPlayerGameMode(sender, args, GameMode.SPECTATOR);
            }
            return this.setPlayerGameMode(sender, args, null);
        }
        return false;
    }

    private boolean setPlayerGameMode(CommandSender sender, String[] args, GameMode gm) {
        if (gm == null && args.length < 1) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        Player player = null;
        boolean thirdperson = false;
        if (sender instanceof ConsoleCommandSender) {
            if (gm == null && args.length < 2 || gm != null && args.length < 1) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                return true;
            }
            player = this.plugin.getServer().getPlayer(gm == null ? args[1] : args[0]);
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_ONLINE");
                return true;
            }
            thirdperson = true;
        }
        if (sender instanceof Player) {
            if (gm == null && args.length == 2) {
                player = this.plugin.getServer().getPlayer(args[1]);
                if (player == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_ONLINE");
                    return true;
                }
            } else if (gm != null && args.length == 1) {
                if (this.ROOT_SUBS.contains((Object)args[0].toUpperCase(Locale.ROOT))) {
                    player = (Player)sender;
                } else {
                    player = this.plugin.getServer().getPlayer(args[0]);
                    thirdperson = true;
                    if (player == null) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_ONLINE");
                        return true;
                    }
                }
            } else {
                player = (Player)sender;
            }
        }
        if (gm == null) {
            if (args[0].length() <= 2) {
                switch (args[0].toLowerCase(Locale.ROOT)) {
                    case "s": {
                        gm = GameMode.SURVIVAL;
                        break;
                    }
                    case "c": {
                        gm = GameMode.CREATIVE;
                        break;
                    }
                    case "a": {
                        gm = GameMode.ADVENTURE;
                        break;
                    }
                    case "sp": {
                        gm = GameMode.SPECTATOR;
                        break;
                    }
                    default: {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_GAMEMODE");
                        return false;
                    }
                }
            } else {
                try {
                    gm = GameMode.valueOf((String)args[0].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_GAMEMODE");
                    return false;
                }
            }
        }
        player.setGameMode(gm);
        if (thirdperson) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_GAMEMODE_CONSOLE", player.getName(), gm.toString());
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_GAMEMODE_PLAYER", gm.toString());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            if (label.equalsIgnoreCase("tgms") || label.equalsIgnoreCase("tgmc") || label.equalsIgnoreCase("tgma") || label.equalsIgnoreCase("tgmsp")) {
                return null;
            }
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2) {
            return null;
        }
        return ImmutableList.of();
    }
}

