/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonTemplate;
import me.eccentric_nz.TARDIS.custommodels.GUILights;
import me.eccentric_nz.TARDIS.custommodels.GUIParticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAllLightLevels;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISLightLevelsInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private String interior_level = "15";
    private String exterior_level = "15";
    private String console_level = "15";
    private final Inventory inventory;

    public TARDISLightLevelsInventory(TARDIS plugin, int id) {
        this.plugin = plugin;
        ResultSetAllLightLevels rs = new ResultSetAllLightLevels(plugin, id);
        if (rs.resultSet()) {
            this.interior_level = "" + LightLevel.interior_level[rs.getInteriorLevel()];
            this.exterior_level = "" + LightLevel.exterior_level[rs.getExteriorLevel()];
            this.console_level = "" + LightLevel.interior_level[rs.getConsoleLevel()];
        }
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Light Levels", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack i_info = ItemStack.of((Material)GUILights.INTERIOR_INFO.material(), (int)1);
        ItemMeta iiim = i_info.getItemMeta();
        iiim.displayName((Component)Component.text((String)"Interior Lights"));
        iiim.lore(List.of(Component.text((String)"Set the light level"), Component.text((String)"of the interior lights")));
        i_info.setItemMeta(iiim);
        ItemStack interior = ItemStack.of((Material)GUILights.INTERIOR.material(), (int)1);
        ItemMeta inim = interior.getItemMeta();
        inim.displayName((Component)Component.text((String)"Interior Lights"));
        inim.lore(List.of(Component.text((String)this.interior_level)));
        interior.setItemMeta(inim);
        ItemStack e_info = ItemStack.of((Material)GUILights.EXTERIOR_INFO.material(), (int)1);
        ItemMeta eiim = e_info.getItemMeta();
        eiim.displayName((Component)Component.text((String)"Exterior Lamp"));
        eiim.lore(List.of(Component.text((String)"Set the light level"), Component.text((String)"of the exterior lamp")));
        e_info.setItemMeta(eiim);
        ItemStack exterior = ItemStack.of((Material)GUILights.EXTERIOR.material(), (int)1);
        ItemMeta exim = exterior.getItemMeta();
        exim.displayName((Component)Component.text((String)"Exterior Lamp"));
        exim.lore(List.of(Component.text((String)this.exterior_level)));
        exterior.setItemMeta(exim);
        ItemStack c_info = ItemStack.of((Material)GUILights.CONSOLE_INFO.material(), (int)1);
        ItemMeta ciim = c_info.getItemMeta();
        ciim.displayName((Component)Component.text((String)"Console Lamp"));
        ciim.lore(List.of(Component.text((String)"Set the light level"), Component.text((String)"of the console lamp")));
        c_info.setItemMeta(ciim);
        ItemStack console = ItemStack.of((Material)GUILights.CONSOLE.material(), (int)1);
        ItemMeta lamp = console.getItemMeta();
        lamp.displayName((Component)Component.text((String)"Console Lamp"));
        lamp.lore(List.of(Component.text((String)this.console_level)));
        console.setItemMeta(lamp);
        ItemStack minus = ItemStack.of((Material)GUIParticle.MINUS.material(), (int)1);
        ItemMeta mim = minus.getItemMeta();
        mim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_LESS")));
        minus.setItemMeta(mim);
        ItemStack plus = ItemStack.of((Material)GUIParticle.PLUS.material(), (int)1);
        ItemMeta pim = plus.getItemMeta();
        pim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_MORE")));
        plus.setItemMeta(pim);
        ItemStack back = ItemStack.of((Material)GUIChameleonTemplate.BACK_HELP.material(), (int)1);
        ItemMeta bk = back.getItemMeta();
        bk.displayName((Component)Component.text((String)this.plugin.getChameleonGuis().getString("BACK_HELP")));
        back.setItemMeta(bk);
        ItemStack close = ItemStack.of((Material)GUILights.CLOSE.material(), (int)1);
        ItemMeta clim = close.getItemMeta();
        clim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(clim);
        return new ItemStack[]{null, i_info, null, null, null, null, null, e_info, null, minus, interior, plus, null, null, null, minus, exterior, plus, null, null, null, null, c_info, null, null, null, null, null, null, null, minus, console, plus, null, null, null, null, null, null, null, null, null, null, null, null, back, null, null, null, null, null, null, null, close};
    }
}

