/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.customblocks.TARDISSeedDisplayItem;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISShowSeedRecipeInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Inventory inventory;
    private final String type;
    private final Material material;

    public TARDISShowSeedRecipeInventory(TARDIS plugin, String type, Material material) {
        this.plugin = plugin;
        this.type = type;
        this.material = material;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)("TARDIS " + type + " seed recipe"), (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getRecipeItems());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getRecipeItems() {
        ItemStack tardis;
        ItemStack[] stacks = new ItemStack[27];
        ItemStack red = ItemStack.of((Material)Material.REDSTONE_TORCH, (int)1);
        ItemStack lapis = ItemStack.of((Material)Material.LAPIS_BLOCK, (int)1);
        ItemStack in_wall = ItemStack.of((Material)Material.ORANGE_WOOL, (int)1);
        ItemMeta in_meta = in_wall.getItemMeta();
        in_meta.displayName((Component)Component.text((String)"Interior walls"));
        in_meta.lore(List.of(Component.text((String)"Any valid Wall/Floor block")));
        in_wall.setItemMeta(in_meta);
        ItemStack in_floor = ItemStack.of((Material)Material.LIGHT_GRAY_WOOL, (int)1);
        ItemMeta fl_meta = in_floor.getItemMeta();
        fl_meta.displayName((Component)Component.text((String)"Interior floors"));
        fl_meta.lore(List.of(Component.text((String)"Any valid Wall/Floor block")));
        in_floor.setItemMeta(fl_meta);
        ItemStack block = ItemStack.of((Material)this.material, (int)1);
        Schematic schm = Consoles.getBY_NAMES().get(this.type);
        NamespacedKey model = TARDISSeedDisplayItem.CUSTOM.getCustomModel();
        if (schm.isCustom()) {
            tardis = ItemStack.of((Material)schm.getSeedMaterial(), (int)1);
        } else {
            try {
                TARDISDisplayItem tdi = TARDISDisplayItemRegistry.valueOf(this.type);
                tardis = ItemStack.of((Material)tdi.getMaterial(), (int)1);
                model = tdi.getCustomModel();
            }
            catch (IllegalArgumentException e) {
                tardis = ItemStack.of((Material)TARDISSeedDisplayItem.CUSTOM.getMaterial(), (int)1);
            }
        }
        ItemMeta seed = tardis.getItemMeta();
        seed.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)model.getKey());
        seed.displayName((Component)ComponentUtils.toGold("TARDIS Seed Block"));
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)this.type));
        lore.add(Component.text((String)"Walls: ORANGE_WOOL"));
        lore.add(Component.text((String)"Floors: LIGHT_GRAY_WOOL"));
        lore.add(Component.text((String)"Chameleon: FACTORY"));
        seed.lore(lore);
        tardis.setItemMeta(seed);
        stacks[0] = red;
        stacks[9] = lapis;
        stacks[11] = in_wall;
        stacks[17] = tardis;
        stacks[18] = block;
        stacks[20] = in_floor;
        return stacks;
    }
}

