/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.weeping_angels;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.utils.MonsterTargetListener;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Damage
implements Listener {
    private final TARDIS plugin;
    private final Material mat;
    private final List<World> angel_tp_worlds = new ArrayList<World>();

    public Damage(TARDIS plugin) {
        this.plugin = plugin;
        this.mat = Material.valueOf((String)plugin.getMonstersConfig().getString("angels.weapon"));
        plugin.getMonstersConfig().getStringList("angels.teleport_worlds").forEach(w -> {
            World world = plugin.getServer().getWorld(w);
            if (world != null) {
                this.angel_tp_worlds.add(world);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBeatUpAngel(EntityDamageByEntityEvent event) {
        EntityType et = event.getEntityType();
        if (et.equals((Object)EntityType.SKELETON)) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            Entity e = event.getDamager();
            if (entity.getPersistentDataContainer().has(TARDISWeepingAngels.ANGEL, PersistentDataType.INTEGER)) {
                Player player;
                if (e instanceof AbstractArrow) {
                    event.setCancelled(true);
                }
                if (e instanceof Player && !(player = (Player)e).getInventory().getItemInMainHand().getType().equals((Object)this.mat)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (entity.getPersistentDataContainer().has(TARDISWeepingAngels.DALEK, PersistentDataType.INTEGER) && e instanceof Player) {
                Player player = (Player)e;
                player.playSound(entity.getLocation(), "dalek_hit", 0.5f, 1.0f);
            }
        }
        if (et.equals((Object)EntityType.PLAYER)) {
            Entity e = event.getDamager();
            if (e instanceof Monster) {
                Monster monster = (Monster)e;
                if (MonsterTargetListener.monsterShouldIgnorePlayer(e, (Player)event.getEntity())) {
                    event.setCancelled(true);
                    monster.setTarget(null);
                    return;
                }
            }
            if (e instanceof Skeleton && e.getPersistentDataContainer().has(TARDISWeepingAngels.ANGEL, PersistentDataType.INTEGER)) {
                Entity t = event.getEntity();
                Player p = (Player)t;
                Location l = this.plugin.getMonstersConfig().getBoolean("angels.teleport_to_location") ? this.getSpecificLocation() : this.getRandomLocation(t.getWorld());
                if (l != null) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.teleport(l), 1L);
                } else {
                    this.plugin.getMessenger().message((CommandSender)p, TardisModule.MONSTERS, "NO_CONFIGURED_WORLDS");
                }
                p.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 300, 5, true, false));
                if (TARDISWeepingAngels.angelsCanSteal()) {
                    this.stealKey(p);
                }
            }
        }
    }

    private Location getRandomLocation(World w) {
        if (!this.angel_tp_worlds.contains(w)) {
            World world = w = !this.angel_tp_worlds.isEmpty() ? this.angel_tp_worlds.get(TARDISConstants.RANDOM.nextInt(this.angel_tp_worlds.size())) : null;
        }
        if (w != null) {
            Chunk[] chunks = w.getLoadedChunks();
            Chunk c = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)];
            int x = c.getX() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int z = c.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int y = w.getHighestBlockYAt(x, z);
            return new Location(w, (double)x, (double)(y + 1), (double)z).add(0.5, 0.0, 0.5);
        }
        return null;
    }

    private Location getSpecificLocation() {
        List locations = this.plugin.getMonstersConfig().getStringList("angels.teleport_locations");
        String l = (String)locations.get(TARDISConstants.RANDOM.nextInt(locations.size()));
        String[] split = l.split(",");
        World w = this.plugin.getServer().getWorld(split[0]);
        double x = TARDISNumberParsers.parseDouble(split[1]) + 0.5;
        double z = TARDISNumberParsers.parseDouble(split[3]) + 0.5;
        double y = TARDISNumberParsers.parseDouble(split[2]);
        return new Location(w, x, y, z);
    }

    private void stealKey(Player p) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack stack : inv.getContents()) {
            ItemMeta im;
            if (stack == null || !stack.hasItemMeta() || !(im = stack.getItemMeta()).hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "TARDIS Key")) continue;
            int amount = stack.getAmount();
            if (amount > 1) {
                stack.setAmount(amount - 1);
            } else {
                int slot = inv.first(stack);
                inv.setItem(slot, ItemStack.of((Material)Material.AIR));
            }
            p.updateInventory();
            this.plugin.getMessenger().message((CommandSender)p, TardisModule.MONSTERS, "The Weeping Angels stole your TARDIS Key");
            break;
        }
    }
}

