/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuilderPreview;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISDesktopPreview {
    private final TARDIS plugin;
    private long delay = 5L;

    public TARDISDesktopPreview(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void create() {
        this.plugin.getMessenger().send((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "PREVIEW_START");
        String dn = this.plugin.getConfig().getString("creation.default_world_name", "TARDIS_TimeVortex");
        World world = this.plugin.getServer().getWorld(dn);
        if (world != null) {
            for (Schematic schematic : Consoles.getBY_NAMES().values()) {
                if (schematic.getPreview() >= 0 || this.hasPreview(schematic)) continue;
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getMessenger().send((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "PREVIEW_SCHM", schematic.getPermission());
                    TARDISBuilderPreview builder = new TARDISBuilderPreview(this.plugin, schematic, world);
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)builder, 1L, 3L);
                    builder.setTask(task);
                }, this.delay);
                this.delay += 1200L;
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().send((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "PREVIEW_END"), this.delay);
        }
    }

    private boolean hasPreview(Schematic schematic) {
        ResultSetTransmat rst = new ResultSetTransmat(this.plugin, schematic.getPreview(), schematic.getPermission());
        return rst.resultSet();
    }
}

