/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorDisguiseEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorUndisguiseEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.LazarusUtils;
import me.eccentric_nz.TARDIS.lazarus.LazarusVariants;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusDisguise;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusInventory;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusLibs;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusPageTwoInventory;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusRunnable;
import me.eccentric_nz.TARDIS.lazarus.TARDISTelevisionInventory;
import me.eccentric_nz.TARDIS.lazarus.TARDISWeepingAngelsMonstersInventory;
import me.eccentric_nz.TARDIS.lazarus.disguise.AGE;
import me.eccentric_nz.TARDIS.lazarus.disguise.FOX;
import me.eccentric_nz.TARDIS.lazarus.disguise.GENE;
import me.eccentric_nz.TARDIS.lazarus.disguise.MUSHROOM_COW;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.skins.SkinUtils;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;

public class TARDISLazarusGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Boolean> snowmen = new HashMap();
    private final HashMap<UUID, Integer> axolotls = new HashMap();
    private final HashMap<UUID, Integer> cats = new HashMap();
    private final HashMap<UUID, Integer> foxes = new HashMap();
    private final HashMap<UUID, Integer> frogs = new HashMap();
    private final HashMap<UUID, Integer> genes = new HashMap();
    private final HashMap<UUID, Integer> horses = new HashMap();
    private final HashMap<UUID, Integer> llamas = new HashMap();
    private final HashMap<UUID, Integer> moos = new HashMap();
    private final HashMap<UUID, Integer> parrots = new HashMap();
    private final HashMap<UUID, Integer> professions = new HashMap();
    private final HashMap<UUID, Integer> puffers = new HashMap();
    private final HashMap<UUID, Integer> rabbits = new HashMap();
    private final HashMap<UUID, Integer> sheep = new HashMap();
    private final HashMap<UUID, Integer> slimes = new HashMap();
    private final HashMap<UUID, Integer> tropics = new HashMap();
    private final HashMap<UUID, Integer> variants = new HashMap();
    private final HashMap<UUID, Integer> wolves = new HashMap();
    private final HashMap<UUID, String> disguises = new HashMap();
    private final List<Integer> slimeSizes = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4));
    private final List<Integer> pufferStates = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    private final List<String> twaMonsters = new ArrayList<String>();
    private final List<String> twaOnly = List.of("DALEK", "DAVROS", "K9", "SATURNYNIAN", "TOCLAFANE");

    public TARDISLazarusGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        for (Monster m : Monster.values()) {
            this.twaMonsters.add(m.toString());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onLazarusClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof TARDISLazarusInventory || holder instanceof TARDISLazarusPageTwoInventory || holder instanceof TARDISWeepingAngelsMonstersInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        Block b = this.plugin.getTrackerKeeper().getLazarus().get(uuid);
        if (b == null) {
            return;
        }
        int max_slot = 40;
        InventoryView view = event.getView();
        if (slot >= 0 && slot <= max_slot) {
            ItemStack is = view.getItem(slot);
            if (is != null) {
                ItemMeta im = is.getItemMeta();
                String display = ComponentUtils.stripColour(im.displayName());
                if (this.twaOnly.contains(display) && !this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                    im.lore(List.of(Component.text((String)"Genetic modification not available!")));
                    is.setItemMeta(im);
                } else {
                    if (is.getType() == Material.PLAYER_HEAD) {
                        display = "PLAYER";
                    }
                    this.disguises.put(uuid, display);
                    this.setSlotFortyEight(view, display, uuid);
                }
            } else {
                this.disguises.put(uuid, "PLAYER");
            }
        } else {
            switch (slot) {
                case 42: {
                    LazarusUtils.pagers.add(uuid);
                    ItemStack pageButton = view.getItem(slot);
                    ItemMeta pageMeta = pageButton.getItemMeta();
                    Object ih = ComponentUtils.stripColour(pageMeta.displayName()).equals(this.plugin.getLanguage().getString("BUTTON_PAGE_1")) ? new TARDISLazarusInventory(this.plugin) : new TARDISLazarusPageTwoInventory(this.plugin);
                    player.openInventory(ih.getInventory());
                    break;
                }
                case 43: {
                    LazarusUtils.pagers.add(uuid);
                    ItemStack skinsButton = view.getItem(slot);
                    ItemMeta skinsMeta = skinsButton.getItemMeta();
                    Object ih = ComponentUtils.stripColour(skinsMeta.displayName()).equals(this.plugin.getLanguage().getString("BUTTON_PAGE_2")) ? new TARDISLazarusPageTwoInventory(this.plugin) : new TARDISTelevisionInventory(this.plugin);
                    player.openInventory(ih.getInventory());
                    break;
                }
                case 44: {
                    LazarusUtils.pagers.add(uuid);
                    ItemStack monstersButton = view.getItem(slot);
                    ItemMeta monstersMeta = monstersButton.getItemMeta();
                    Object ih = ComponentUtils.stripColour(monstersMeta.displayName()).equals("TARDIS Television") ? new TARDISTelevisionInventory(this.plugin) : new TARDISWeepingAngelsMonstersInventory(this.plugin);
                    player.openInventory(ih.getInventory());
                    break;
                }
                case 45: {
                    ItemStack masterButton = view.getItem(slot);
                    ItemMeta masterMeta = masterButton.getItemMeta();
                    if (TARDISPermission.hasPermission(player, "tardis.themaster")) {
                        if (this.plugin.getTrackerKeeper().getImmortalityGate().isEmpty()) {
                            boolean isOff = ComponentUtils.stripColour((Component)masterMeta.lore().getFirst()).equals(this.plugin.getLanguage().getString("SET_OFF", "OFF"));
                            TextComponent onoff = isOff ? Component.text((String)this.plugin.getLanguage().getString("SET_ON", "ON")) : Component.text((String)this.plugin.getLanguage().getString("SET_OFF", "OFF"));
                            masterMeta.lore(List.of(onoff));
                            CustomModelDataComponent component = masterMeta.getCustomModelDataComponent();
                            component.setFloats(isOff ? List.of(Float.valueOf(252.0f)) : List.of(Float.valueOf(152.0f)));
                            masterMeta.setCustomModelDataComponent(component);
                        } else {
                            masterMeta.lore(List.of(Component.text((String)"The Master Race is already"), Component.text((String)(" set to " + this.plugin.getTrackerKeeper().getImmortalityGate() + "!")), Component.text((String)"Try again later.")));
                        }
                    } else {
                        masterMeta.lore(List.of(Component.text((String)"You do not have permission"), Component.text((String)"to be The Master!")));
                    }
                    masterButton.setItemMeta(masterMeta);
                    break;
                }
                case 47: {
                    ItemStack ageButton = view.getItem(slot);
                    ItemMeta ageMeta = ageButton.getItemMeta();
                    String onoff = ComponentUtils.stripColour((Component)ageMeta.lore().getFirst()).equals("ADULT") ? "BABY" : "ADULT";
                    ageMeta.lore(List.of(Component.text((String)onoff)));
                    ageButton.setItemMeta(ageMeta);
                    break;
                }
                case 48: {
                    if (!this.disguises.containsKey(uuid)) break;
                    this.setSlotFortyEight(view, this.disguises.get(uuid), uuid);
                    break;
                }
                case 49: {
                    ItemStack optionsButton = view.getItem(slot);
                    ItemMeta optionsMeta = optionsButton.getItemMeta();
                    List lore = optionsMeta.lore();
                    int pos = lore.size() - 1;
                    TextComponent truefalse = ComponentUtils.stripColour((Component)lore.get(pos)).equals("FALSE") ? Component.text((String)"TRUE", (TextColor)NamedTextColor.GREEN) : Component.text((String)"FALSE", (TextColor)NamedTextColor.RED);
                    lore.set(pos, truefalse);
                    optionsMeta.lore(lore);
                    optionsButton.setItemMeta(optionsMeta);
                    break;
                }
                case 51: {
                    LazarusUtils.pagers.remove(uuid);
                    this.plugin.getTrackerKeeper().getGeneticManipulation().add(uuid);
                    this.close(player);
                    TARDISLazarusRunnable runnable = new TARDISLazarusRunnable(this.plugin, b);
                    int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
                    runnable.setTaskID(taskId);
                    TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (this.twaMonsters.contains(this.disguises.get(uuid))) {
                            LazarusUtils.twaOff(player);
                        } else if (this.plugin.isDisguisesOnServer()) {
                            TARDISLazarusLibs.removeDisguise(player);
                        } else {
                            TARDISLazarusDisguise.removeDisguise(player);
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GENETICS_RESTORED");
                        this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                    }, 80L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        LazarusUtils.openDoor(b);
                        this.untrack(uuid, true);
                        this.plugin.getTrackerKeeper().getGeneticallyModified().remove(uuid);
                    }, 100L);
                    break;
                }
                case 52: {
                    LazarusUtils.pagers.remove(uuid);
                    this.plugin.getTrackerKeeper().getGeneticManipulation().add(uuid);
                    this.close(player);
                    TARDISLazarusRunnable runnable = new TARDISLazarusRunnable(this.plugin, b);
                    int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
                    runnable.setTaskID(taskId);
                    TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (this.plugin.isDisguisesOnServer()) {
                            TARDISLazarusLibs.removeDisguise(player);
                        } else {
                            TARDISLazarusDisguise.removeDisguise(player);
                        }
                        if (this.isReversedPolarity(view)) {
                            this.plugin.getTrackerKeeper().setImmortalityGate(player.getName());
                            if (this.plugin.isDisguisesOnServer()) {
                                TARDISLazarusLibs.runImmortalityGate(player);
                            } else {
                                TARDISLazarusDisguise.runImmortalityGate(player);
                            }
                            this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "The Master (aka " + player.getName() + ") has cloned his genetic template to all players. Behold the Master Race!");
                            this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorDisguiseEvent(player, player.getName()));
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                this.plugin.getServer().getOnlinePlayers().forEach(p -> {
                                    if (this.plugin.isDisguisesOnServer()) {
                                        TARDISLazarusLibs.removeDisguise(p);
                                    } else {
                                        TARDISLazarusDisguise.removeDisguise(p);
                                    }
                                });
                                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "Lord Rassilon has reset the Master Race back to human form.");
                                this.plugin.getTrackerKeeper().setImmortalityGate("");
                                this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                            }, 3600L);
                        } else if (this.disguises.containsKey(uuid)) {
                            String disguise = this.disguises.get(uuid);
                            LazarusUtils.twaOff(player);
                            if (this.twaMonsters.contains(disguise)) {
                                if (this.twaOnly.contains(disguise)) {
                                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "twa disguise " + disguise + " on " + String.valueOf(player.getUniqueId()));
                                } else {
                                    Skin skin = Monster.valueOf(disguise).getSkin();
                                    this.plugin.getSkinChanger().set(player, skin);
                                    SkinUtils.setExtras(player, skin);
                                    SkinUtils.SKINNED.put(uuid, skin);
                                }
                            } else {
                                EntityType dt = EntityType.valueOf((String)disguise);
                                Object[] options = null;
                                switch (dt) {
                                    case AXOLOTL: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getAxolotlVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getAxolotlVariant(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case FROG: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getFrogVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getFrogVariant(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case CAT: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getCatType(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getCatType(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case PANDA: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getGene(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{GENE.getFromPandaGene(this.getGene(view)), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case DONKEY: 
                                    case MULE: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, null, this.getBoolean(view), !this.getBoolean(view) && this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getBoolean(view), AGE.getFromBoolean(!this.getBoolean(view) && this.getBaby(view))};
                                        break;
                                    }
                                    case PILLAGER: 
                                    case BAT: 
                                    case CREEPER: 
                                    case ENDERMAN: 
                                    case BLAZE: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, null, this.getBoolean(view), false).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getBoolean(view)};
                                        break;
                                    }
                                    case SHEEP: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getColor(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getColor(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case WOLF: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getWolfVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getWolfVariant(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case CHICKEN: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getChickenVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getChickenVariant(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case COW: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getCowVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getCowVariant(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case PIG: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getPigVariant(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getPigVariant(view), this.getBoolean(view), AGE.getFromBoolean(!this.getBoolean(view) && this.getBaby(view))};
                                        break;
                                    }
                                    case HORSE: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getHorseColor(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getHorseColor(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case LLAMA: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getLlamaColor(view), this.getBoolean(view), !this.getBoolean(view) && this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getLlamaColor(view), this.getBoolean(view), AGE.getFromBoolean(!this.getBoolean(view) && this.getBaby(view))};
                                        break;
                                    }
                                    case OCELOT: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, null, this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case PARROT: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getParrotVariant(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getParrotVariant(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case RABBIT: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getRabbitType(view), this.getBoolean(view), this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getRabbitType(view), this.getBoolean(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case VILLAGER: 
                                    case ZOMBIE_VILLAGER: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getProfession(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getProfession(view), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case SLIME: 
                                    case MAGMA_CUBE: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getSlimeSize(view), false, false).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.getSlimeSize(view)};
                                        break;
                                    }
                                    case TURTLE: 
                                    case ZOMBIE: 
                                    case BEE: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, null, false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case SNOW_GOLEM: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.snowmen.get(uuid), false, false).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.snowmen.get(uuid)};
                                        break;
                                    }
                                    case PUFFERFISH: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.puffers.get(uuid), false, false).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{this.puffers.get(uuid)};
                                        break;
                                    }
                                    case TROPICAL_FISH: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, TropicalFish.Pattern.values()[this.tropics.get(uuid)], false, false).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{TropicalFish.Pattern.values()[this.tropics.get(uuid)]};
                                        break;
                                    }
                                    case MOOSHROOM: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getMushroomCowVariant(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{MUSHROOM_COW.getFromMushroomCowType(this.getMushroomCowVariant(view)), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    case FOX: {
                                        if (this.plugin.isDisguisesOnServer()) {
                                            new TARDISLazarusLibs(player, disguise, this.getFoxType(view), false, this.getBaby(view)).createDisguise();
                                            break;
                                        }
                                        options = new Object[]{FOX.getFromFoxType(this.getFoxType(view)), AGE.getFromBoolean(this.getBaby(view))};
                                        break;
                                    }
                                    default: {
                                        if (!this.plugin.isDisguisesOnServer()) break;
                                        new TARDISLazarusLibs(player, disguise, null, false, false).createDisguise();
                                    }
                                }
                                if (!this.plugin.isDisguisesOnServer()) {
                                    new TARDISLazarusDisguise(this.plugin, player, dt, options).createDisguise();
                                }
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GENETICS_MODIFIED", disguise);
                            this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorDisguiseEvent(player, disguise));
                        }
                    }, 80L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        LazarusUtils.openDoor(b);
                        this.untrack(uuid, false);
                        this.plugin.getTrackerKeeper().getGeneticallyModified().add(uuid);
                    }, 100L);
                    break;
                }
                case 53: {
                    LazarusUtils.pagers.remove(uuid);
                    this.close(player);
                    LazarusUtils.openDoor(b);
                    this.untrack(uuid, false);
                    break;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onLazarusClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.plugin.getTrackerKeeper().getGeneticManipulation().contains(uuid)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (holder instanceof TARDISLazarusInventory || holder instanceof TARDISLazarusPageTwoInventory || holder instanceof TARDISWeepingAngelsMonstersInventory || holder instanceof TARDISTelevisionInventory) {
            Block b = this.plugin.getTrackerKeeper().getLazarus().get(uuid);
            if (b != null && b.getRelative(BlockFace.SOUTH).getType().equals((Object)Material.COBBLESTONE_WALL)) {
                b.getRelative(BlockFace.SOUTH).setType(Material.AIR);
                b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).setType(Material.AIR);
            }
            this.untrack(uuid, false);
            LazarusUtils.pagers.remove(uuid);
        }
    }

    private void untrack(UUID uuid, boolean remove) {
        if (!LazarusUtils.pagers.contains(uuid)) {
            this.plugin.getTrackerKeeper().getLazarus().remove(uuid);
        }
        if (remove) {
            this.disguises.remove(uuid);
        }
        this.sheep.remove(uuid);
        this.horses.remove(uuid);
        this.cats.remove(uuid);
        this.professions.remove(uuid);
        this.slimes.remove(uuid);
        this.plugin.getTrackerKeeper().getGeneticManipulation().remove(uuid);
    }

    private void setSlotFortyEight(InventoryView i, String d, UUID uuid) {
        String t = null;
        switch (d) {
            case "FROG": {
                int o = this.frogs.containsKey(uuid) ? (this.frogs.get(uuid) + 1 < 3 ? this.frogs.get(uuid) + 1 : 0) : 0;
                t = LazarusVariants.NAMES.get(o);
                this.frogs.put(uuid, o);
                break;
            }
            case "AXOLOTL": {
                int o = this.axolotls.containsKey(uuid) ? (this.axolotls.get(uuid) + 1 < 5 ? this.axolotls.get(uuid) + 1 : 0) : 0;
                t = Axolotl.Variant.values()[o].toString();
                this.axolotls.put(uuid, o);
                break;
            }
            case "SNOWMAN": {
                boolean derp = this.snowmen.containsKey(uuid) ? this.snowmen.get(uuid) == false : true;
                this.snowmen.put(uuid, derp);
                t = derp ? "Pumpkin head" : "Derp face";
                break;
            }
            case "SHEEP": {
                int o = this.sheep.containsKey(uuid) ? (this.sheep.get(uuid) + 1 < 16 ? this.sheep.get(uuid) + 1 : 0) : 0;
                t = DyeColor.values()[o].toString();
                this.sheep.put(uuid, o);
                break;
            }
            case "WOLF": {
                int o = this.wolves.containsKey(uuid) ? (this.wolves.get(uuid) + 1 < 9 ? this.wolves.get(uuid) + 1 : 0) : 0;
                t = LazarusVariants.WOLF_NAMES.get(o);
                this.wolves.put(uuid, o);
                break;
            }
            case "CHICKEN": 
            case "COW": 
            case "PIG": {
                int o = this.variants.containsKey(uuid) ? (this.variants.get(uuid) + 1 < 3 ? this.variants.get(uuid) + 1 : 0) : 0;
                t = LazarusVariants.NAMES.get(o);
                this.variants.put(uuid, o);
                break;
            }
            case "HORSE": {
                int o = this.horses.containsKey(uuid) ? (this.horses.get(uuid) + 1 < 7 ? this.horses.get(uuid) + 1 : 0) : 0;
                t = Horse.Color.values()[o].toString();
                this.horses.put(uuid, o);
                break;
            }
            case "LLAMA": {
                int o = this.llamas.containsKey(uuid) ? (this.llamas.get(uuid) + 1 < 4 ? this.llamas.get(uuid) + 1 : 0) : 0;
                t = Llama.Color.values()[o].toString();
                this.llamas.put(uuid, o);
                break;
            }
            case "CAT": {
                int o = this.cats.containsKey(uuid) ? (this.cats.get(uuid) + 1 < 11 ? this.cats.get(uuid) + 1 : 0) : 0;
                t = LazarusVariants.CAT_NAMES.get(o);
                this.cats.put(uuid, o);
                break;
            }
            case "FOX": {
                int o = this.foxes.containsKey(uuid) ? (this.foxes.get(uuid) + 1 < 2 ? this.foxes.get(uuid) + 1 : 0) : 0;
                t = Fox.Type.values()[o].toString();
                this.foxes.put(uuid, o);
                break;
            }
            case "RABBIT": {
                int o = this.rabbits.containsKey(uuid) ? (this.rabbits.get(uuid) + 1 < 7 ? this.rabbits.get(uuid) + 1 : 0) : 0;
                t = Rabbit.Type.values()[o].toString();
                this.rabbits.put(uuid, o);
                break;
            }
            case "PARROT": {
                int o = this.parrots.containsKey(uuid) ? (this.parrots.get(uuid) + 1 < 5 ? this.parrots.get(uuid) + 1 : 0) : 0;
                t = Parrot.Variant.values()[o].toString();
                this.parrots.put(uuid, o);
                break;
            }
            case "VILLAGER": 
            case "ZOMBIE_VILLAGER": {
                int o = this.professions.containsKey(uuid) ? (this.professions.get(uuid) + 1 < 6 ? this.professions.get(uuid) + 1 : 1) : 1;
                t = LazarusVariants.PROFESSION_NAMES.get(o);
                this.professions.put(uuid, o);
                break;
            }
            case "SLIME": 
            case "MAGMA_CUBE": {
                int o = this.slimes.containsKey(uuid) ? (this.slimes.get(uuid) + 1 < 3 ? this.slimes.get(uuid) + 1 : 0) : 0;
                t = this.slimeSizes.get(o).toString();
                this.slimes.put(uuid, o);
                break;
            }
            case "MUSHROOM_COW": {
                int o = this.moos.containsKey(uuid) ? (this.moos.get(uuid) + 1 < 2 ? this.moos.get(uuid) + 1 : 0) : 0;
                t = MushroomCow.Variant.values()[o].toString();
                this.moos.put(uuid, o);
                break;
            }
            case "PUFFERFISH": {
                int o = this.puffers.containsKey(uuid) ? (this.puffers.get(uuid) + 1 < 3 ? this.puffers.get(uuid) + 1 : 0) : 0;
                t = this.pufferStates.get(o).toString();
                this.puffers.put(uuid, o);
                break;
            }
            case "TROPICAL_FISH": {
                int o = this.tropics.containsKey(uuid) ? (this.tropics.get(uuid) + 1 < 12 ? this.tropics.get(uuid) + 1 : 0) : 0;
                t = TropicalFish.Pattern.values()[o].toString();
                this.tropics.put(uuid, o);
                break;
            }
            case "PANDA": {
                int o = this.genes.containsKey(uuid) ? (this.genes.get(uuid) + 1 < 7 ? this.genes.get(uuid) + 1 : 0) : 0;
                t = Panda.Gene.values()[o].toString();
                this.genes.put(uuid, o);
                break;
            }
        }
        if (t != null) {
            ItemStack is = i.getItem(48);
            ItemMeta im = is.getItemMeta();
            im.lore(List.of(Component.text((String)t)));
            is.setItemMeta(im);
        }
    }

    private boolean isReversedPolarity(InventoryView i) {
        ItemStack is = i.getItem(45);
        ItemMeta im = is.getItemMeta();
        return ComponentUtils.stripColour((Component)im.lore().getFirst()).equals(this.plugin.getLanguage().getString("SET_ON", "ON"));
    }

    private DyeColor getColor(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return DyeColor.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return DyeColor.WHITE;
        }
    }

    private Horse.Color getHorseColor(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Horse.Color.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Horse.Color.WHITE;
        }
    }

    private MushroomCow.Variant getMushroomCowVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return MushroomCow.Variant.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return MushroomCow.Variant.RED;
        }
    }

    private Llama.Color getLlamaColor(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Llama.Color.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Llama.Color.CREAMY;
        }
    }

    private Axolotl.Variant getAxolotlVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Axolotl.Variant.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Axolotl.Variant.WILD;
        }
    }

    private Frog.Variant getFrogVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.FROG_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Frog.Variant.TEMPERATE);
    }

    private Cat.Type getCatType(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.CAT_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Cat.Type.TABBY);
    }

    private Fox.Type getFoxType(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Fox.Type.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Fox.Type.RED;
        }
    }

    private Panda.Gene getGene(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Panda.Gene.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Panda.Gene.NORMAL;
        }
    }

    private Parrot.Variant getParrotVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Parrot.Variant.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Parrot.Variant.GRAY;
        }
    }

    private Rabbit.Type getRabbitType(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        try {
            return Rabbit.Type.valueOf((String)ComponentUtils.stripColour((Component)im.lore().getFirst()));
        }
        catch (IllegalArgumentException e) {
            return Rabbit.Type.BROWN;
        }
    }

    private Wolf.Variant getWolfVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.WOLF_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Wolf.Variant.PALE);
    }

    private Chicken.Variant getChickenVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.CHICKEN_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Chicken.Variant.TEMPERATE);
    }

    private Cow.Variant getCowVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.COW_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Cow.Variant.TEMPERATE);
    }

    private Pig.Variant getPigVariant(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.PIG_VARIANTS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Pig.Variant.TEMPERATE);
    }

    private Villager.Profession getProfession(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        return LazarusVariants.PROFESSIONS.getOrDefault(ComponentUtils.stripColour((Component)im.lore().getFirst()), Villager.Profession.FARMER);
    }

    private int getSlimeSize(InventoryView i) {
        ItemStack is = i.getItem(48);
        ItemMeta im = is.getItemMeta();
        int size = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)im.lore().getFirst()));
        return size == 0 ? 2 : size;
    }

    private boolean getBaby(InventoryView i) {
        ItemStack is = i.getItem(47);
        ItemMeta im = is.getItemMeta();
        return ComponentUtils.stripColour((Component)im.lore().getFirst()).equals("BABY");
    }

    private boolean getBoolean(InventoryView i) {
        ItemStack is = i.getItem(49);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        int pos = lore.size() - 1;
        return ComponentUtils.stripColour((Component)lore.get(pos)).equals("TRUE");
    }
}

