/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.GUILights;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.lights.Sequences;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISLightsInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final UUID uuid;
    private final Inventory inventory;

    public TARDISLightsInventory(TARDIS plugin, int id, UUID uuid) {
        this.plugin = plugin;
        this.id = id;
        this.uuid = uuid;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Lights", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack lit;
        ItemStack block;
        Material material;
        TardisLight lightPref;
        String on;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        String off = this.plugin.getLanguage().getString("SET_OFF", "OFF");
        String lights_onoff = on = this.plugin.getLanguage().getString("SET_ON", "ON");
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            lights_onoff = tardis.isLightsOn() ? on : off;
        }
        ItemStack[] stacks = new ItemStack[54];
        ResultSetLightPrefs rslp = new ResultSetLightPrefs(this.plugin);
        if (rslp.fromID(this.id)) {
            lightPref = rslp.getLight();
            material = rslp.getMaterial();
        } else {
            lightPref = this.getCurrentLight(this.id);
            material = Material.BONE_BLOCK;
            String levels = this.getCurrentLevels(this.id);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", this.id);
            set.put("light", lightPref.toString());
            set.put("material", "BONE_BLOCK");
            set.put("levels", levels);
            this.plugin.getQueryFactory().doSyncInsert("light_prefs", set);
        }
        ItemStack lights = ItemStack.of((Material)GUILights.LIGHT_INFO.material(), (int)1);
        ItemMeta sim = lights.getItemMeta();
        sim.displayName((Component)Component.text((String)"Light Type"));
        sim.lore(List.of(Component.text((String)"Choose a light"), Component.text((String)"from the options"), Component.text((String)"on the right.")));
        lights.setItemMeta(sim);
        stacks[GUILights.LIGHT_INFO.slot()] = lights;
        int i = 1;
        for (TardisLight tl : TardisLight.values()) {
            ItemStack light = ItemStack.of((Material)tl.getOn().getMaterial(), (int)1);
            ItemMeta lim = light.getItemMeta();
            lim.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(tl.toString())));
            if (lightPref == tl) {
                lim.lore(List.of(Component.text((String)"Current light")));
            }
            light.setItemMeta(lim);
            stacks[i] = light;
            if (i % 9 == 8) {
                i += 2;
                continue;
            }
            ++i;
        }
        ItemStack block_info = ItemStack.of((Material)GUILights.BLOCK_INFO.material(), (int)1);
        ItemMeta blim = block_info.getItemMeta();
        blim.displayName((Component)Component.text((String)"Variable Light Block"));
        blim.lore(List.of(Component.text((String)"Only applies to variable lights."), Component.text((String)"Click the button to the right"), Component.text((String)"to open the blocks menu.")));
        block_info.setItemMeta(blim);
        stacks[GUILights.BLOCK_INFO.slot()] = block_info;
        ItemStack block_button = ItemStack.of((Material)GUILights.BLOCK_BUTTON.material(), (int)1);
        ItemMeta bbim = block_button.getItemMeta();
        bbim.displayName((Component)Component.text((String)"Block Type"));
        block_button.setItemMeta(bbim);
        stacks[GUILights.BLOCK_BUTTON.slot()] = block_button;
        stacks[29] = block = ItemStack.of((Material)material, (int)1);
        ItemStack ch_info = ItemStack.of((Material)GUILights.CHANGE_INFO.material(), (int)1);
        ItemMeta chim = ch_info.getItemMeta();
        chim.displayName((Component)Component.text((String)"Change your light type"));
        chim.lore(List.of(Component.text((String)"Select a light from above,"), Component.text((String)"if the light is variable"), Component.text((String)"also select a block type."), Component.text((String)"Click the button to start.")));
        ch_info.setItemMeta(chim);
        stacks[GUILights.CHANGE_INFO.slot()] = ch_info;
        ItemStack chan = ItemStack.of((Material)GUILights.CHANGE_LIGHTS.material(), (int)1);
        ItemMeta geim = chan.getItemMeta();
        geim.displayName((Component)Component.text((String)"Change Lights"));
        chan.setItemMeta(geim);
        stacks[GUILights.CHANGE_LIGHTS.slot()] = chan;
        ItemStack c_info = ItemStack.of((Material)GUILights.CONVERT_INFO.material(), (int)1);
        ItemMeta ciim = c_info.getItemMeta();
        ciim.displayName((Component)Component.text((String)"Convert blocks to lights"));
        ciim.lore(List.of(Component.text((String)"Click the button to the"), Component.text((String)"right to select a block"), Component.text((String)"type to convert.")));
        c_info.setItemMeta(ciim);
        stacks[GUILights.CONVERT_INFO.slot()] = c_info;
        ItemStack emitting = ItemStack.of((Material)GUILights.SELECT_LIGHT.material(), (int)1);
        ItemMeta emim = emitting.getItemMeta();
        emim.displayName((Component)Component.text((String)"Select block to convert"));
        emitting.setItemMeta(emim);
        stacks[GUILights.SELECT_LIGHT.slot()] = emitting;
        Material lightEmitting = Material.REDSTONE_LAMP;
        if (Sequences.CONVERTERS.containsKey(this.uuid)) {
            lightEmitting = Material.valueOf((String)Sequences.CONVERTERS.get(this.uuid));
        }
        stacks[43] = lit = ItemStack.of((Material)lightEmitting, (int)1);
        ItemStack con = ItemStack.of((Material)GUILights.CONVERT_LIGHTS.material(), (int)1);
        ItemMeta vert = con.getItemMeta();
        vert.displayName((Component)Component.text((String)"Convert blocks to lights"));
        vert.lore(List.of(Component.text((String)"Will change the block"), Component.text((String)"type to the left to"), Component.text((String)"the TARDIS light you"), Component.text((String)"have selected above.")));
        con.setItemMeta(vert);
        stacks[GUILights.CONVERT_LIGHTS.slot()] = con;
        ItemStack lig = ItemStack.of((Material)GUILights.LIGHT_SWITCH.material(), (int)1);
        ItemMeta swi = lig.getItemMeta();
        swi.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_LIGHTS")));
        swi.lore(List.of(Component.text((String)lights_onoff)));
        CustomModelDataComponent lscomponent = swi.getCustomModelDataComponent();
        List<Float> floats = lights_onoff.equals(off) ? SwitchVariant.BUTTON_LIGHTS_OFF.getFloats() : SwitchVariant.BUTTON_LIGHTS_ON.getFloats();
        lscomponent.setFloats(floats);
        swi.setCustomModelDataComponent(lscomponent);
        CustomModelDataComponent lcomponent = swi.getCustomModelDataComponent();
        lcomponent.setFloats(floats);
        swi.setCustomModelDataComponent(lcomponent);
        lig.setItemMeta(swi);
        stacks[GUILights.LIGHT_SWITCH.slot()] = lig;
        ItemStack llis = ItemStack.of((Material)GUILights.BUTTON_LIGHT_LEVELS.material(), (int)1);
        ItemMeta llim = llis.getItemMeta();
        llim.displayName((Component)Component.text((String)"Light Levels"));
        llis.setItemMeta(llim);
        stacks[GUILights.BUTTON_LIGHT_LEVELS.slot()] = llis;
        ItemStack sequence = ItemStack.of((Material)GUILights.BUTTON_LIGHT_SEQUENCE.material(), (int)1);
        ItemMeta qim = sequence.getItemMeta();
        qim.displayName((Component)Component.text((String)"Run Light Sequence"));
        sequence.setItemMeta(qim);
        stacks[GUILights.BUTTON_LIGHT_SEQUENCE.slot()] = sequence;
        ItemStack edit = ItemStack.of((Material)GUILights.EDIT_LIGHT_SEQUENCE.material(), (int)1);
        ItemMeta eim = edit.getItemMeta();
        eim.displayName((Component)Component.text((String)"Edit Light Sequence"));
        edit.setItemMeta(eim);
        stacks[GUILights.EDIT_LIGHT_SEQUENCE.slot()] = edit;
        ItemStack close = ItemStack.of((Material)GUILights.CLOSE.material(), (int)1);
        ItemMeta clim = close.getItemMeta();
        clim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(clim);
        stacks[GUILights.CLOSE.slot()] = close;
        return stacks;
    }

    private String getCurrentLevels(int id) {
        ResultSetLightLevel rsl = new ResultSetLightLevel(this.plugin);
        if (rsl.fromTypeAndID(50, id)) {
            int level = LightLevel.interior_level[rsl.getLevel()];
            return String.format("%s:%s:%s:%s:%s:%s:%s:%s:%s", level, level, level, level, level, level, level, level, level);
        }
        return "15:15:15:15:15:15:15:15:15";
    }

    private TardisLight getCurrentLight(int id) {
        TARDISDisplayItem tdi;
        Block block;
        ItemDisplay display;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetLamps rsl = new ResultSetLamps(this.plugin, where, true);
        if (rsl.resultSet() && (display = TARDISDisplayItemUtils.get(block = rsl.getData().getFirst())) != null && (tdi = TARDISDisplayItemUtils.get(display)) != null && tdi.isLight()) {
            return TardisLight.getFromDisplayItem(tdi);
        }
        return TardisLight.TENTH;
    }
}

