/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class TARDISGameModeSwitcher
implements Listener {
    private final TARDIS plugin;

    public TARDISGameModeSwitcher(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGameModeWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        String world = player.getWorld().getName();
        if (this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".enabled") && !TARDISPermission.hasPermission(player, "tardis.gamemode.bypass")) {
            try {
                GameMode gm = GameMode.valueOf((String)this.plugin.getPlanetsConfig().getString("planets." + world + ".gamemode"));
                player.setGameMode(gm);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Could not get GameMode for world change: '" + world + "'");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGameModeJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String world = player.getWorld().getName();
        if (this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".enabled") && !TARDISPermission.hasPermission(player, "tardis.gamemode.bypass")) {
            try {
                GameMode gm = GameMode.valueOf((String)this.plugin.getPlanetsConfig().getString("planets." + world + ".gamemode"));
                player.setGameMode(gm);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Could not get GameMode for world join: '" + world + "'");
            }
        }
    }
}

