/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.api;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISTrackerInstanceKeeper;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.TARDISData;
import me.eccentric_nz.TARDIS.api.TARDISException;
import me.eccentric_nz.TARDIS.api.TARDISRandomNether;
import me.eccentric_nz.TARDIS.api.TARDISRandomOverworld;
import me.eccentric_nz.TARDIS.api.TARDISRandomTheEnd;
import me.eccentric_nz.TARDIS.api.TardisAPI;
import me.eccentric_nz.TARDIS.blueprints.BlueprintBase;
import me.eccentric_nz.TARDIS.blueprints.BlueprintBlaster;
import me.eccentric_nz.TARDIS.blueprints.BlueprintConsole;
import me.eccentric_nz.TARDIS.blueprints.BlueprintFeature;
import me.eccentric_nz.TARDIS.blueprints.BlueprintPreset;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.blueprints.BlueprintShop;
import me.eccentric_nz.TARDIS.blueprints.BlueprintSonic;
import me.eccentric_nz.TARDIS.blueprints.BlueprintTravel;
import me.eccentric_nz.TARDIS.blueprints.BlueprintType;
import me.eccentric_nz.TARDIS.blueprints.BlueprintVortexManipulator;
import me.eccentric_nz.TARDIS.blueprints.BlueprintWeepingAngels;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.interior.TARDISAbandoned;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.desktop.TARDISWallFloorRunnable;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.flight.TARDISTakeoff;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.travel.TARDISPluginRespect;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.TARDIS.utility.TARDISUtils;
import me.eccentric_nz.TARDIS.utility.WeightedChoice;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.equip.MonsterEquipment;
import me.eccentric_nz.tardisweepingangels.equip.RemoveEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.empty_child.EmptyChildEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessMonkEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.monsters.silent.SilentEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.toclafane.ToclafaneEquipment;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.utils.FollowerChecker;
import me.eccentric_nz.tardisweepingangels.utils.HeadBuilder;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDII
implements TardisAPI {
    private static final WeightedChoice<World.Environment> weightedChoice = new WeightedChoice<World.Environment>().add(70.0, World.Environment.NORMAL).add(15.0, World.Environment.NETHER).add(15.0, World.Environment.THE_END);
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Integer> getTimelordMap() {
        HashMap<String, Integer> timelords = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT tardis_id, owner FROM " + TARDIS.plugin.getPrefix() + "tardis";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    timelords.put(rs.getString("owner"), rs.getInt("tardis_id"));
                }
            }
        }
        catch (SQLException e) {
            TARDIS.plugin.debug("ResultSet error for tardis table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                TARDIS.plugin.debug("Error closing tardis table! " + e.getMessage());
            }
        }
        return timelords;
    }

    @Override
    public Location getTARDISCurrentLocation(int id) {
        ResultSetCurrentFromId rs = new ResultSetCurrentFromId(TARDIS.plugin, id);
        if (rs.resultSet()) {
            return rs.getCurrent().location();
        }
        return null;
    }

    @Override
    public Location getTARDISCurrentLocation(Player p) {
        return this.getTARDISCurrentLocation(p.getUniqueId());
    }

    @Override
    public Location getTARDISCurrentLocation(UUID uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetCurrentLocation rs = new ResultSetCurrentLocation(TARDIS.plugin, where);
        if (rs.resultSet()) {
            return new Location(rs.getWorld(), (double)rs.getX(), (double)rs.getY(), (double)rs.getZ());
        }
        return null;
    }

    @Override
    public Location getTARDISNextLocation(int id) {
        ResultSetNextLocation rs = new ResultSetNextLocation(TARDIS.plugin, id);
        if (rs.resultSet()) {
            return new Location(rs.getWorld(), (double)rs.getX(), (double)rs.getY(), (double)rs.getZ());
        }
        return null;
    }

    @Override
    public TARDISData getTARDISMapData(int id) {
        TARDISData data = null;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            String owner = tardis.getOwner();
            Location current = this.getTARDISCurrentLocation(id);
            String console = tardis.getSchematic().getPermission().toUpperCase(Locale.ROOT);
            String chameleon = tardis.getPreset().toString();
            String door = "Closed";
            for (Map.Entry<Location, TARDISTeleportLocation> map : TARDIS.plugin.getTrackerKeeper().getPortals().entrySet()) {
                if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned() || id != map.getValue().getTardisId()) continue;
                door = "Open";
                break;
            }
            String powered = tardis.isPoweredOn() ? "Yes" : "No";
            String siege = tardis.isSiegeOn() ? "Yes" : "No";
            String abandoned = tardis.isAbandoned() ? "Yes" : "No";
            List<String> occupants = this.getPlayersInTARDIS(id);
            data = new TARDISData(owner, current, console, chameleon, door, powered, siege, abandoned, occupants);
        }
        return data;
    }

    @Override
    public Location getRandomLocation(List<String> worlds, World.Environment environment, Parameters param) {
        if (environment == null && ((environment = weightedChoice.next()) == World.Environment.NETHER && !TARDIS.plugin.getConfig().getBoolean("travel.nether") || environment == World.Environment.THE_END && !TARDIS.plugin.getConfig().getBoolean("travel.the_end"))) {
            environment = World.Environment.NORMAL;
        }
        return switch (environment) {
            case World.Environment.NETHER -> new TARDISRandomNether(TARDIS.plugin, worlds, param).getlocation();
            case World.Environment.THE_END -> new TARDISRandomTheEnd(TARDIS.plugin, worlds, param).getlocation();
            default -> new TARDISRandomOverworld(TARDIS.plugin, worlds, param).getlocation();
        };
    }

    @Override
    public Location getRandomLocation(List<String> worlds, World.Environment environment, Player p) {
        return this.getRandomLocation(this.getWorlds(), null, new Parameters(p, Flag.getAPIFlags()));
    }

    @Override
    public Location getRandomLocation(List<String> worlds, Player p) {
        return this.getRandomLocation(this.getWorlds(), null, new Parameters(p, Flag.getAPIFlags()));
    }

    @Override
    public Location getRandomOverworldLocation(Player p) {
        return this.getRandomLocation(this.getWorlds(), World.Environment.NORMAL, p);
    }

    @Override
    public Location getRandomOverworldLocation(String world, Player p) {
        return this.getRandomLocation(List.of(world), World.Environment.NORMAL, p);
    }

    @Override
    public Location getRandomNetherLocation(Player p) {
        return this.getRandomLocation(this.getWorlds(), World.Environment.NETHER, p);
    }

    @Override
    public Location getRandomNetherLocation(String world, Player p) {
        return this.getRandomLocation(List.of(world), World.Environment.NETHER, p);
    }

    @Override
    public Location getRandomEndLocation(Player p) {
        return this.getRandomLocation(this.getWorlds(), World.Environment.THE_END, p);
    }

    @Override
    public Location getRandomEndLocation(String world, Player p) {
        return this.getRandomLocation(List.of(world), World.Environment.THE_END, p);
    }

    @Override
    public List<String> getWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        Bukkit.getWorlds().forEach(w -> {
            String name = w.getName();
            if (TARDIS.plugin.getPlanetsConfig().getBoolean("planets." + name + ".time_travel")) {
                if (!TARDIS.plugin.getPlanetsConfig().getBoolean("planets." + name + ".enabled") && TARDIS.plugin.getWorldManager() == WorldManager.MULTIVERSE) {
                    worlds.add(TARDIS.plugin.getMVHelper().getAlias(name));
                } else {
                    worlds.add(TARDISAliasResolver.getWorldAlias(name));
                }
            }
        });
        return worlds;
    }

    @Override
    public List<String> getOverWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        Bukkit.getWorlds().forEach(w -> {
            String name = w.getName();
            if (TARDIS.plugin.getPlanetsConfig().getBoolean("planets." + name + ".time_travel") && w.getEnvironment() != World.Environment.NETHER && w.getEnvironment() != World.Environment.THE_END) {
                if (!TARDIS.plugin.getPlanetsConfig().getBoolean("planets." + name + ".enabled") && TARDIS.plugin.getWorldManager() == WorldManager.MULTIVERSE) {
                    worlds.add(TARDIS.plugin.getMVHelper().getAlias(name));
                } else {
                    worlds.add(TARDISAliasResolver.getWorldAlias(name));
                }
            }
        });
        return worlds;
    }

    @Override
    public String getTARDISPlayerIsIn(Player p) {
        return this.getTARDISPlayerIsIn(p.getUniqueId());
    }

    @Override
    public String getTARDISPlayerIsIn(UUID uuid) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (p != null && p.isOnline()) {
            Object str = " is not in any TARDIS.";
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTravellers rs = new ResultSetTravellers(TARDIS.plugin, where, false);
            if (rs.resultSet()) {
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", rs.getTardis_id());
                ResultSetTardis rst = new ResultSetTardis(TARDIS.plugin, wheret, "", false);
                if (rst.resultSet()) {
                    Tardis tardis = rst.getTardis();
                    str = tardis.isAbandoned() ? " is in an abandoned TARDIS." : " is in " + tardis.getOwner() + "'s TARDIS.";
                }
            }
            return p.getName() + (String)str;
        }
        return "Player is not online.";
    }

    @Override
    public int getIdOfTARDISPlayerIsIn(Player p) {
        return this.getIdOfTARDISPlayerIsIn(p.getUniqueId());
    }

    @Override
    public int getIdOfTARDISPlayerIsIn(UUID uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTravellers rs = new ResultSetTravellers(TARDIS.plugin, where, false);
        if (rs.resultSet()) {
            return rs.getTardis_id();
        }
        return -1;
    }

    @Override
    public List<String> getPlayersInTARDIS(int id) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTravellers rs = new ResultSetTravellers(TARDIS.plugin, where, true);
        if (rs.resultSet()) {
            rs.getData().forEach(u -> {
                Player p = Bukkit.getPlayer((UUID)u);
                if (p != null && p.isOnline()) {
                    list.add(p.getName());
                }
            });
        }
        return list;
    }

    @Override
    public List<String> getPlayersInTARDIS(Player p) {
        return this.getPlayersInTARDIS(p.getUniqueId());
    }

    @Override
    public List<String> getPlayersInTARDIS(UUID uuid) {
        ResultSetTardisID rs = new ResultSetTardisID(TARDIS.plugin);
        if (rs.fromUUID(uuid.toString())) {
            return this.getPlayersInTARDIS(rs.getTardisId());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getTARDISCompanions(int id) {
        String companions;
        ArrayList<String> list = new ArrayList<String>();
        ResultSetTardisCompanions rs = new ResultSetTardisCompanions(TARDIS.plugin);
        if (rs.fromID(id) && !(companions = rs.getCompanions()).isEmpty()) {
            for (String s : companions.split(":")) {
                Player p = Bukkit.getPlayer((String)s);
                if (p == null || !p.isOnline()) continue;
                list.add(p.getName());
            }
        }
        return list;
    }

    @Override
    public List<String> getTARDISCompanions(Player p) {
        return this.getTARDISCompanions(p.getUniqueId());
    }

    @Override
    public List<String> getTARDISCompanions(UUID uuid) {
        String companions;
        ArrayList<String> list = new ArrayList<String>();
        ResultSetTardisCompanions rs = new ResultSetTardisCompanions(TARDIS.plugin);
        if (rs.fromUUID(uuid.toString()) && !(companions = rs.getCompanions()).isEmpty()) {
            for (String s : companions.split(":")) {
                Player p = Bukkit.getPlayer((String)s);
                if (p == null || !p.isOnline()) continue;
                list.add(p.getName());
            }
        }
        return list;
    }

    @Override
    public boolean isPlayerInZeroRoom(Player p) {
        return this.isPlayerInZeroRoom(p.getUniqueId());
    }

    @Override
    public boolean isPlayerInZeroRoom(UUID uuid) {
        return TARDIS.plugin.getTrackerKeeper().getZeroRoomOccupants().contains(uuid);
    }

    @Override
    public boolean isPlayerGeneticallyModified(Player p) {
        return this.isPlayerGeneticallyModified(p.getUniqueId());
    }

    @Override
    public boolean isPlayerGeneticallyModified(UUID uuid) {
        return TARDIS.plugin.getTrackerKeeper().getGeneticallyModified().contains(uuid);
    }

    @Override
    public TARDISUtils getUtils() {
        return TARDIS.plugin.getUtils();
    }

    @Override
    public TARDISLocationGetters getLocationUtils() {
        return TARDIS.plugin.getLocationUtils();
    }

    @Override
    public TARDISPluginRespect getRespect() {
        return TARDIS.plugin.getPluginRespect();
    }

    @Override
    public HashMap<String, ShapedRecipe> getShapedRecipes() {
        return TARDIS.plugin.getFigura().getShapedRecipes();
    }

    @Override
    public HashMap<String, ShapelessRecipe> getShapelessRecipes() {
        return TARDIS.plugin.getIncomposita().getShapelessRecipes();
    }

    @Override
    public ItemStack getTARDISShapeItem(String item, Player player) {
        ArrayList<TextComponent> lore;
        ItemMeta im;
        ItemStack result;
        if (item.endsWith("Save Storage Disk") || item.endsWith("Preset Storage Disk") || item.endsWith("Biome Storage Disk") || item.endsWith("Player Storage Disk") || item.endsWith("Bowl of Custard") || item.endsWith("Jelly Baby")) {
            recipe = TARDIS.plugin.getIncomposita().getShapelessRecipes().get(item);
            result = recipe.getResult();
        } else {
            recipe = TARDIS.plugin.getFigura().getShapedRecipes().get(item);
            if (recipe == null) {
                return null;
            }
            result = recipe.getResult();
        }
        if (item.endsWith("TARDIS Invisibility Circuit")) {
            im = result.getItemMeta();
            lore = im.lore();
            TextComponent uses = TARDIS.plugin.getConfig().getInt("circuits.uses.invisibility", 5) == 0 || !TARDIS.plugin.getConfig().getBoolean("circuits.damage") ? Component.text((String)"unlimited", (TextColor)NamedTextColor.YELLOW) : Component.text((String)TARDIS.plugin.getConfig().getString("circuits.uses.invisibility", "5"), (TextColor)NamedTextColor.YELLOW);
            lore.set(1, uses);
            im.lore((List)lore);
            result.setItemMeta(im);
        }
        if (item.endsWith("Blank Storage Disk") || item.endsWith("Save Storage Disk") || item.endsWith("Preset Storage Disk") || item.endsWith("Biome Storage Disk") || item.endsWith("Player Storage Disk") || item.endsWith("Authorised Control Disk")) {
            im = result.getItemMeta();
            im.addItemFlags(ItemFlag.values());
            im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            result.setItemMeta(im);
        }
        if (item.endsWith("TARDIS Key") || item.endsWith("Authorised Control Disk")) {
            im = result.getItemMeta();
            im.getPersistentDataContainer().set(TARDIS.plugin.getTimeLordUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
            lore = im.lore();
            if (lore == null) {
                lore = new ArrayList<TextComponent>();
            }
            String what = item.endsWith("TARDIS Key") ? "key" : "disk";
            lore.add((TextComponent)Component.text((String)("This " + what + " belongs to"), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
            lore.add((TextComponent)Component.text((String)player.getName(), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
            im.lore(lore);
            result.setItemMeta(im);
        }
        return result;
    }

    @Override
    public HashMap<Schematic, ShapedRecipe> getSeedRecipes() {
        return TARDIS.plugin.getObstructionum().getSeedRecipes();
    }

    @Override
    public ItemStack getTARDISSeedItem(String schematic) {
        if (Consoles.getBY_NAMES().containsKey(schematic)) {
            ItemStack is;
            Schematic s = Consoles.getBY_NAMES().get(schematic);
            NamespacedKey model = TARDISDisplayItem.CUSTOM.getCustomModel();
            if (s.isCustom()) {
                is = ItemStack.of((Material)s.getSeedMaterial(), (int)1);
            } else {
                try {
                    TARDISDisplayItem tdi = TARDISDisplayItem.valueOf(s.getPermission().toUpperCase(Locale.ROOT));
                    model = tdi.getCustomModel();
                    is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
                }
                catch (IllegalArgumentException e) {
                    TARDIS.plugin.debug("Could not get display item for console! " + e.getMessage());
                    is = ItemStack.of((Material)TARDISDisplayItem.CUSTOM.getMaterial(), (int)1);
                }
            }
            ItemMeta im = is.getItemMeta();
            im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)model.getKey());
            im.displayName((Component)ComponentUtils.toGold("TARDIS Seed Block"));
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            lore.add(Component.text((String)schematic));
            lore.add(Component.text((String)"Walls: ORANGE_WOOL"));
            lore.add(Component.text((String)"Floors: LIGHT_GRAY_WOOL"));
            lore.add(Component.text((String)"Chameleon: FACTORY"));
            im.lore(lore);
            is.setItemMeta(im);
            return is;
        }
        return null;
    }

    @Override
    public List<BlueprintType> getBlueprints() {
        return null;
    }

    @Override
    public ItemStack getTARDISBlueprintItem(String item, Player player) {
        String[] split = item.split("_");
        if (split.length < 3) {
            return null;
        }
        try {
            BlueprintType type = BlueprintType.valueOf(split[1].toUpperCase(Locale.ROOT));
            int sub = 11 + split[1].length();
            String upper = item.toUpperCase(Locale.ROOT).substring(sub);
            String perm = switch (type) {
                case BlueprintType.CONSOLE -> {
                    BlueprintConsole console = BlueprintConsole.valueOf(upper);
                    yield console.getPermission();
                }
                case BlueprintType.FEATURE -> {
                    BlueprintFeature feature = BlueprintFeature.valueOf(upper);
                    yield feature.getPermission();
                }
                case BlueprintType.PRESET -> {
                    BlueprintPreset preset = BlueprintPreset.valueOf(upper);
                    yield preset.getPermission();
                }
                case BlueprintType.ROOM -> {
                    BlueprintRoom room = BlueprintRoom.valueOf(upper);
                    yield room.getPermission();
                }
                case BlueprintType.SONIC -> {
                    BlueprintSonic sonic = BlueprintSonic.valueOf(upper);
                    yield sonic.getPermission();
                }
                case BlueprintType.TRAVEL -> {
                    BlueprintTravel travel = BlueprintTravel.valueOf(upper);
                    yield travel.getPermission();
                }
                case BlueprintType.SHOP -> {
                    BlueprintShop shop = BlueprintShop.valueOf(upper);
                    yield shop.getPermission();
                }
                case BlueprintType.VORTEX_MANIPULATOR -> {
                    BlueprintVortexManipulator manipulator = BlueprintVortexManipulator.valueOf(upper);
                    yield manipulator.getPermission();
                }
                case BlueprintType.WEEPING_ANGELS -> {
                    BlueprintWeepingAngels angel = BlueprintWeepingAngels.valueOf(upper);
                    yield angel.getPermission();
                }
                case BlueprintType.BLASTER -> {
                    BlueprintBlaster blaster = BlueprintBlaster.valueOf(upper);
                    yield blaster.getPermission();
                }
                default -> {
                    BlueprintBase base = BlueprintBase.valueOf(upper);
                    yield base.getPermission();
                }
            };
            if (perm != null) {
                ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_MELLOHI, (int)1);
                ItemMeta im = is.getItemMeta();
                PersistentDataContainer pdc = im.getPersistentDataContainer();
                pdc.set(TARDIS.plugin.getTimeLordUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
                pdc.set(TARDIS.plugin.getBlueprintKey(), PersistentDataType.STRING, (Object)perm);
                im.displayName((Component)ComponentUtils.toWhite("TARDIS Blueprint Disk"));
                List<TextComponent> lore = List.of(Component.text((String)TARDISStringUtils.capitalise(item)), Component.text((String)"Valid only for"), Component.text((String)player.getName()));
                im.lore(lore);
                im.addItemFlags(ItemFlag.values());
                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                is.setItemMeta(im);
                return is;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public List<String> getWallFloorBlocks() {
        ArrayList<String> blocks = new ArrayList<String>();
        TARDISWalls.BLOCKS.forEach(m -> blocks.add(m.toString()));
        return blocks;
    }

    @Override
    public boolean setDestination(int id, Location location, boolean travel) {
        ResultSetCurrentFromId rs = new ResultSetCurrentFromId(TARDIS.plugin, id);
        if (rs.resultSet()) {
            Current current = rs.getCurrent();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("world", location.getWorld().getName());
            set.put("x", location.getBlockX());
            set.put("y", location.getBlockY());
            set.put("z", location.getBlockZ());
            set.put("direction", current.direction().toString());
            set.put("submarine", 0);
            TARDIS.plugin.getQueryFactory().doUpdate("next", set, where);
            if (travel) {
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", id);
                ResultSetTardis rst = new ResultSetTardis(TARDIS.plugin, wheret, "", false);
                if (rst.resultSet()) {
                    Player player = Bukkit.getServer().getPlayer(rst.getTardis().getUuid());
                    TARDIS.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(TARDIS.plugin.getArtronConfig().getInt("random"), TravelType.RANDOM));
                    new TARDISTakeoff(TARDIS.plugin).run(id, player, rst.getTardis().getBeacon());
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setDestination(UUID uuid, Location location, boolean travel) {
        ResultSetTardisID rst = new ResultSetTardisID(TARDIS.plugin);
        if (rst.fromUUID(uuid.toString())) {
            return this.setDestination(rst.getTardisId(), location, travel);
        }
        return false;
    }

    @Override
    public boolean setDestination(Player player, Location location, boolean travel) {
        return this.setDestination(player.getUniqueId(), location, travel);
    }

    @Override
    public Tardis getTardisData(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rs.resultSet()) {
            return rs.getTardis();
        }
        return null;
    }

    @Override
    public Tardis getTardisData(UUID uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rs.resultSet()) {
            return rs.getTardis();
        }
        return null;
    }

    @Override
    public Tardis getTardisData(Player player) {
        return this.getTardisData(player.getUniqueId());
    }

    @Override
    public boolean setChameleonPreset(int id, ChameleonPreset preset, boolean rebuild) {
        TARDISTrackerInstanceKeeper keeper = TARDIS.plugin.getTrackerKeeper();
        if (keeper.getDematerialising().contains(id) || keeper.getMaterialising().contains(id) || keeper.getDestinationVortex().containsKey(id) || keeper.getInVortex().contains(id)) {
            return false;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("chameleon_preset", preset.toString());
        TARDIS.plugin.getQueryFactory().doSyncUpdate("tardis", set, where);
        if (rebuild) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(TARDIS.plugin, id);
            if (!rsc.resultSet()) {
                return false;
            }
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(TARDIS.plugin, wheret, "", false);
            if (rs.resultSet()) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)rs.getTardis().getUuid());
                BuildData bd = new BuildData(player.getUniqueId().toString());
                bd.setDirection(rsc.getCurrent().direction());
                bd.setLocation(rsc.getCurrent().location());
                bd.setMalfunction(false);
                bd.setOutside(false);
                bd.setPlayer(player);
                bd.setRebuild(true);
                bd.setSubmarine(false);
                bd.setTardisID(id);
                bd.setThrottle(SpaceTimeThrottle.REBUILD);
                TARDIS.plugin.getPresetBuilder().buildPreset(bd);
                TARDIS.plugin.getTrackerKeeper().getInVortex().add(id);
                HashMap<String, Object> whereh = new HashMap<String, Object>();
                whereh.put("tardis_id", id);
                HashMap<String, Object> seth = new HashMap<String, Object>();
                seth.put("hidden", 0);
                TARDIS.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setChameleonPreset(UUID uuid, ChameleonPreset preset, boolean rebuild) {
        ResultSetTardisID rst = new ResultSetTardisID(TARDIS.plugin);
        if (rst.fromUUID(uuid.toString())) {
            return this.setChameleonPreset(rst.getTardisId(), preset, rebuild);
        }
        return false;
    }

    @Override
    public boolean setChameleonPreset(Player player, ChameleonPreset preset, boolean rebuild) {
        return this.setChameleonPreset(player.getUniqueId(), preset, rebuild);
    }

    @Override
    public void spawnAbandonedTARDIS(Location location, String type, ChameleonPreset preset, COMPASS direction) throws TARDISException {
        if (!Consoles.getBY_NAMES().containsKey(type.toUpperCase(Locale.ROOT))) {
            throw new TARDISException("Not a valid Console type");
        }
        if (preset == ChameleonPreset.ITEM) {
            throw new TARDISException("Preset must not be custom item model");
        }
        if (!TARDIS.plugin.getConfig().getBoolean("abandon.enabled")) {
            throw new TARDISException("Abandoned TARDISes are not allowed on this server");
        }
        if (!TARDIS.plugin.getConfig().getBoolean("creation.default_world")) {
            throw new TARDISException("TARDIS must be configured to create TARDISes in a default world");
        }
        Schematic schm = Consoles.getBY_NAMES().get(type.toUpperCase(Locale.ROOT));
        new TARDISAbandoned(TARDIS.plugin).spawn(location, schm, preset, "", direction, null);
    }

    @Override
    public void spawnAbandonedTARDIS(Location location) {
        try {
            this.spawnAbandonedTARDIS(location, "BUDGET", ChameleonPreset.FACTORY, COMPASS.SOUTH);
        }
        catch (TARDISException ex) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, ex.getMessage());
        }
    }

    @Override
    public String setDesktopWallAndFloor(int id, String wall, String floor, boolean artron) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rst = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rst.resultSet()) {
            try {
                return this.setDesktopWallAndFloor(rst.getTardis().getUuid(), wall, floor, artron);
            }
            catch (TARDISException ex) {
                TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.SEVERE, ex.getMessage());
                return "";
            }
        }
        return "";
    }

    @Override
    public String setDesktopWallAndFloor(UUID uuid, String wall, String floor, boolean artron) throws TARDISException {
        Material w = Material.getMaterial((String)wall);
        Material f = Material.getMaterial((String)floor);
        if (!TARDISWalls.BLOCKS.contains(w)) {
            throw new TARDISException("Not a valid wall type");
        }
        if (!TARDISWalls.BLOCKS.contains(f)) {
            throw new TARDISException("Not a valid wall type");
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(TARDIS.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            Schematic current_console = tardis.getSchematic();
            TARDISUpgradeData tud = new TARDISUpgradeData();
            tud.setSchematic(current_console);
            tud.setPrevious(current_console);
            tud.setLevel(tardis.getArtronLevel());
            tud.setWall(wall);
            tud.setFloor(floor);
            TARDISWallFloorRunnable ttr = new TARDISWallFloorRunnable(TARDIS.plugin, uuid, tud);
            long delay = Math.round(20.0 / TARDIS.plugin.getConfig().getDouble("growth.room_speed"));
            int task = TARDIS.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)TARDIS.plugin, (Runnable)ttr, 5L, delay);
            ttr.setTaskID(task);
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(TARDIS.plugin, uuid.toString());
            if (rsp.resultSet()) {
                return rsp.getWall() + "," + rsp.getFloor();
            }
            return "ORANGE_WOOL,LIGHT_GRAY_WOOL";
        }
        return "";
    }

    @Override
    public void addShapedRecipe(String key, ShapedRecipe recipe) {
        TARDIS.plugin.getFigura().getShapedRecipes().put(key, recipe);
    }

    @Override
    public void addShapelessRecipe(String key, ShapelessRecipe recipe) {
        TARDIS.plugin.getIncomposita().getShapelessRecipes().put(key, recipe);
    }

    @Override
    public void setAngelEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.WEEPING_ANGEL, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setWarriorEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.ICE_WARRIOR, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setCyberEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.CYBERMAN, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setDalekEquipment(LivingEntity le, boolean disguise) {
        DalekEquipment.set(le, disguise);
    }

    @Override
    public void setDalekSecEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.DALEK_SEC, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setDavrosEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.DAVROS, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setEmptyChildEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.EMPTY_CHILD, le, disguise).setHelmetAndInvisibility();
        if (!disguise) {
            EmptyChildEquipment.setSpeed(le);
        }
    }

    @Override
    public void setHathEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.HATH, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setHeadlessMonkEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.HEADLESS_MONK, le, disguise).setHelmetAndInvisibility();
        HeadlessMonkEquipment.setTasks(le);
    }

    @Override
    public void setHeavenlyHostEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.HEAVENLY_HOST, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setMireEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.MIRE, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setSeaDevilEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.SEA_DEVIL, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setSlitheenEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.SLITHEEN, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setJudoonEquipment(LivingEntity entity, boolean disguise) {
        new Equipper(Monster.JUDOON, entity, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setK9Equipment(Player player, Entity entity, boolean disguise) {
        K9Equipment.set((OfflinePlayer)player, (LivingEntity)entity, disguise);
    }

    @Override
    public void setOodEquipment(LivingEntity entity, boolean disguise) {
        new Equipper(Monster.OOD, entity, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setRacnossEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.RACNOSS, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setSilentEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.SILENT, le, disguise).setHelmetAndInvisibility();
        SilentEquipment.setGuardian(le);
    }

    @Override
    public void setSilurianEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.SILURIAN, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setSontaranEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.SONTARAN, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setStraxEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.STRAX, le, disguise).setHelmetAndInvisibility();
        if (!disguise) {
            le.customName((Component)Component.text((String)"Strax"));
        }
    }

    @Override
    public void setToclafaneEquipment(Entity armorStand, boolean disguise) {
        ToclafaneEquipment.set(armorStand, disguise);
    }

    @Override
    public void setVashtaNeradaEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.VASHTA_NERADA, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void setZygonEquipment(LivingEntity le, boolean disguise) {
        new Equipper(Monster.ZYGON, le, disguise).setHelmetAndInvisibility();
    }

    @Override
    public void removeEquipment(Player p) {
        RemoveEquipment.set(p);
    }

    @Override
    public boolean isWeepingAngelMonster(Entity entity) {
        return MonsterEquipment.isMonster(entity);
    }

    @Override
    public Monster getWeepingAngelMonsterType(Entity entity) {
        return MonsterEquipment.getMonsterType(entity);
    }

    @Override
    public FollowerChecker isClaimedMonster(Entity entity, UUID uuid) {
        if (TARDIS.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            FollowerChecker fc = new FollowerChecker();
            fc.checkEntity(entity, uuid);
            return fc;
        }
        return null;
    }

    @Override
    public void setFollowing(Entity husk, Player player) {
        ((TWAFollower)husk).setFollowing(true);
    }

    @Override
    public ItemStack getHead(Monster monster) {
        return HeadBuilder.getItemStack(monster);
    }

    @Override
    public ItemStack getK9() {
        return HeadBuilder.getK9();
    }
}

