/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TARDISExcitationRunnable
implements Runnable {
    private final TARDIS plugin;
    private final Location location;
    private final Player player;
    private final List<Block> snow = new ArrayList<Block>();
    public int task;
    private int i = 0;

    TARDISExcitationRunnable(TARDIS plugin, Location l, Player player) {
        this.plugin = plugin;
        this.location = l;
        this.player = player;
    }

    @Override
    public void run() {
        if (this.i < 100) {
            TARDISParticles.sendSnowParticles(this.location, this.player);
            this.player.getNearbyEntities(16.0, 16.0, 16.0).forEach(e -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    TARDISParticles.sendSnowParticles(this.location, p);
                }
            });
            if (this.i % 5 == 0) {
                Location s = this.calculateLocationInCircle(this.location);
                s.setY((double)(this.location.getWorld().getHighestBlockYAt(s) + 1));
                Block b = s.getBlock();
                if (b.isEmpty() && b.getRelative(BlockFace.DOWN).getType().isOccluding()) {
                    b.setBlockData(TARDISConstants.SNOW);
                    this.snow.add(b);
                }
            }
            ++this.i;
        } else {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            this.plugin.getTrackerKeeper().getExcitation().remove(this.player.getUniqueId());
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.snow.forEach(block -> block.setBlockData(TARDISConstants.AIR)), 40L);
        }
    }

    private Location calculateLocationInCircle(Location location) {
        double angle = TARDISConstants.RANDOM.nextDouble() * Math.PI * 2.0;
        double radius = TARDISConstants.RANDOM.nextDouble() * 6.0;
        double x = radius * Math.cos(angle);
        double z = radius * Math.sin(angle);
        return location.clone().add(x, 0.0, z);
    }
}

