/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.custommodels.keys.BoneDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ChemistryEquipment;
import me.eccentric_nz.TARDIS.custommodels.keys.ClassicDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.LampVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.LanternVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.LightVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Schism;
import me.eccentric_nz.TARDIS.custommodels.keys.SeedBlock;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicItem;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Whoniverse;
import me.eccentric_nz.TARDIS.custommodels.keys.Wool;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum TARDISDisplayItem {
    ANCIENT(SeedBlock.ANCIENT.getKey(), Material.SCULK),
    ARS(SeedBlock.ARS.getKey(), Material.QUARTZ_BLOCK),
    BIGGER(SeedBlock.BIGGER.getKey(), Material.GOLD_BLOCK),
    BONE(SeedBlock.BONE.getKey(), Material.WAXED_OXIDIZED_CUT_COPPER),
    BUDGET(SeedBlock.BUDGET.getKey(), Material.IRON_BLOCK),
    CAVE(SeedBlock.CAVE.getKey(), Material.DRIPSTONE_BLOCK),
    COPPER(SeedBlock.COPPER.getKey(), Material.COPPER_BLOCK),
    CORAL(SeedBlock.CORAL.getKey(), Material.FIRE_CORAL_BLOCK),
    CURSED(SeedBlock.CURSED.getKey(), Material.BLACK_CONCRETE),
    DELTA(SeedBlock.DELTA.getKey(), Material.CRYING_OBSIDIAN),
    DELUXE(SeedBlock.DELUXE.getKey(), Material.DIAMOND_BLOCK),
    DIVISION(SeedBlock.DIVISION.getKey(), Material.PINK_GLAZED_TERRACOTTA),
    ELEVENTH(SeedBlock.ELEVENTH.getKey(), Material.EMERALD_BLOCK),
    ENDER(SeedBlock.ENDER.getKey(), Material.PURPUR_BLOCK),
    FACTORY(SeedBlock.FACTORY.getKey(), Material.GRAY_CONCRETE),
    FIFTEENTH(SeedBlock.FIFTEENTH.getKey(), Material.OCHRE_FROGLIGHT),
    FUGITIVE(SeedBlock.FUGITIVE.getKey(), Material.POLISHED_DEEPSLATE),
    HOSPITAL(SeedBlock.HOSPITAL.getKey(), Material.WHITE_CONCRETE),
    MASTER(SeedBlock.MASTER.getKey(), Material.NETHER_BRICKS),
    MECHANICAL(SeedBlock.MECHANICAL.getKey(), Material.POLISHED_ANDESITE),
    ORIGINAL(SeedBlock.ORIGINAL.getKey(), Material.PACKED_MUD),
    PLANK(SeedBlock.PLANK.getKey(), Material.BOOKSHELF),
    PYRAMID(SeedBlock.PYRAMID.getKey(), Material.SANDSTONE_STAIRS),
    REDSTONE(SeedBlock.REDSTONE.getKey(), Material.REDSTONE_BLOCK),
    ROTOR(SeedBlock.ROTOR.getKey(), Material.HONEYCOMB_BLOCK),
    RUSTIC(SeedBlock.RUSTIC.getKey(), Material.COPPER_BULB),
    STEAMPUNK(SeedBlock.STEAMPUNK.getKey(), Material.COAL_BLOCK),
    THIRTEENTH(SeedBlock.THIRTEENTH.getKey(), Material.HORN_CORAL_BLOCK),
    TOM(SeedBlock.TOM.getKey(), Material.LAPIS_BLOCK),
    TWELFTH(SeedBlock.TWELFTH.getKey(), Material.PRISMARINE),
    WAR(SeedBlock.WAR.getKey(), Material.WHITE_TERRACOTTA),
    WEATHERED(SeedBlock.WEATHERED.getKey(), Material.WEATHERED_COPPER),
    SMALL(SeedBlock.SMALL.getKey(), Material.COBBLESTONE),
    MEDIUM(SeedBlock.MEDIUM.getKey(), Material.COBBLESTONE),
    TALL(SeedBlock.TALL.getKey(), Material.COBBLESTONE),
    LEGACY_BIGGER(SeedBlock.LEGACY_BIGGER.getKey(), Material.ORANGE_GLAZED_TERRACOTTA),
    LEGACY_DELUXE(SeedBlock.LEGACY_DELUXE.getKey(), Material.LIME_GLAZED_TERRACOTTA),
    LEGACY_ELEVENTH(SeedBlock.LEGACY_ELEVENTH.getKey(), Material.CYAN_GLAZED_TERRACOTTA),
    LEGACY_REDSTONE(SeedBlock.LEGACY_REDSTONE.getKey(), Material.RED_GLAZED_TERRACOTTA),
    CUSTOM(SeedBlock.CUSTOM.getKey(), Material.POLISHED_BLACKSTONE),
    GROW(SeedBlock.GROW.getKey(), Material.LIGHT_GRAY_TERRACOTTA, Material.NETHERITE_BLOCK),
    ADVANCED_CONSOLE(Whoniverse.ADVANCED_CONSOLE.getKey(), Material.JUKEBOX),
    ARTRON_CAPACITOR_STORAGE(Whoniverse.EYE_STORAGE.getKey(), Material.GRAY_SHULKER_BOX),
    ARTRON_FURNACE(Whoniverse.ARTRON_FURNACE.getKey(), Material.FURNACE),
    ARTRON_FURNACE_LIT(Whoniverse.ARTRON_FURNACE_LIT.getKey(), Material.FURNACE),
    BLUE_BOX(Wool.BLUE_BOX.getKey(), Material.BLUE_WOOL, Material.BLUE_DYE),
    COG(Wool.COG.getKey(), Material.GRAY_WOOL, Material.GRAY_DYE),
    DISK_STORAGE(Whoniverse.DISK_STORAGE.getKey(), Material.NOTE_BLOCK),
    TELEVISION(Whoniverse.TV.getKey(), Material.BROWN_STAINED_GLASS),
    HEXAGON(Wool.HEXAGON.getKey(), Material.ORANGE_WOOL, Material.ORANGE_DYE),
    ROUNDEL(Wool.ROUNDEL.getKey(), Material.WHITE_WOOL, Material.WHITE_DYE),
    ROUNDEL_OFFSET(Wool.ROUNDEL_OFFSET.getKey(), Material.WHITE_WOOL, Material.LIGHT_GRAY_DYE),
    PANDORICA(Whoniverse.PANDORICA.getKey(), Material.BLACK_CONCRETE),
    SIEGE_CUBE(Whoniverse.SIEGE_CUBE.getKey(), Material.CYAN_CONCRETE),
    THE_MOMENT(Wool.THE_MOMENT.getKey(), Material.BROWN_WOOL, Material.REDSTONE_BLOCK),
    UNTEMPERED_SCHISM(Schism.UNTEMPERED_SCHISM.getKey(), Material.ANCIENT_DEBRIS),
    DOOR(TardisDoorVariant.TARDIS_DOOR_CLOSED.getKey(), Material.IRON_DOOR, Material.IRON_DOOR),
    DOOR_OPEN(TardisDoorVariant.TARDIS_DOOR_OPEN.getKey(), Material.IRON_DOOR),
    DOOR_BOTH_OPEN(TardisDoorVariant.TARDIS_DOOR_EXTRA.getKey(), Material.IRON_DOOR),
    BONE_DOOR(BoneDoorVariant.BONE_DOOR_CLOSED.getKey(), Material.IRON_DOOR, Material.BIRCH_DOOR),
    BONE_DOOR_OPEN(BoneDoorVariant.BONE_DOOR_OPEN.getKey(), Material.BIRCH_DOOR),
    CLASSIC_DOOR(ClassicDoorVariant.CLASSIC_DOOR_CLOSED.getKey(), Material.IRON_DOOR, Material.CHERRY_DOOR),
    CLASSIC_DOOR_OPEN(ClassicDoorVariant.CLASSIC_DOOR_OPEN.getKey(), Material.CHERRY_DOOR),
    CUSTOM_DOOR(null, Material.IRON_DOOR),
    SONIC_DOCK(SonicItem.SONIC_DOCK_OFF.getKey(), Material.FLOWER_POT),
    SONIC_GENERATOR(SonicItem.SONIC_GENERATOR.getKey(), Material.FLOWER_POT),
    BLUE_LAMP(LampVariant.BLUE_LAMP.getKey(), Material.REDSTONE_LAMP),
    GREEN_LAMP(LampVariant.GREEN_LAMP.getKey(), Material.REDSTONE_LAMP),
    PURPLE_LAMP(LampVariant.PURPLE_LAMP.getKey(), Material.REDSTONE_LAMP),
    RED_LAMP(LampVariant.RED_LAMP.getKey(), Material.REDSTONE_LAMP),
    BLUE_LAMP_ON(LanternVariant.BLUE_LAMP_ON.getKey(), Material.SEA_LANTERN),
    GREEN_LAMP_ON(LanternVariant.GREEN_LAMP_ON.getKey(), Material.SEA_LANTERN),
    PURPLE_LAMP_ON(LanternVariant.PURPLE_LAMP_ON.getKey(), Material.SEA_LANTERN),
    RED_LAMP_ON(LanternVariant.RED_LAMP_ON.getKey(), Material.SEA_LANTERN),
    COMPOUND(ChemistryEquipment.COMPOUND.getKey(), Material.ORANGE_CONCRETE),
    CONSTRUCTOR(ChemistryEquipment.CONSTRUCTOR.getKey(), Material.LIGHT_BLUE_CONCRETE),
    CREATIVE(ChemistryEquipment.CREATIVE.getKey(), Material.LIGHT_GRAY_CONCRETE),
    LAB(ChemistryEquipment.LAB.getKey(), Material.YELLOW_CONCRETE),
    PRODUCT(ChemistryEquipment.PRODUCT.getKey(), Material.LIME_CONCRETE),
    REDUCER(ChemistryEquipment.REDUCER.getKey(), Material.MAGENTA_CONCRETE),
    HEAT_BLOCK(ChemistryEquipment.HEAT_BLOCK.getKey(), Material.RED_CONCRETE),
    LIGHT_BULB(LightVariant.BULB.getKey(), Material.WAXED_COPPER_BULB, Material.COPPER_BULB),
    LIGHT_CLASSIC(Wool.CLASSIC.getKey(), Material.GRAY_WOOL, Material.TORCH),
    LIGHT_CLASSIC_OFFSET(Wool.CLASSIC_OFFSET.getKey(), Material.GRAY_WOOL, Material.SOUL_TORCH),
    LIGHT_TENTH(Wool.TENTH.getKey(), Material.GRAY_WOOL, Material.ORANGE_DYE),
    LIGHT_ELEVENTH(Wool.ELEVENTH.getKey(), Material.GRAY_WOOL, Material.YELLOW_DYE),
    LIGHT_TWELFTH(Wool.TWELFTH.getKey(), Material.GRAY_WOOL, Material.CYAN_DYE),
    LIGHT_THIRTEENTH(Wool.THIRTEENTH.getKey(), Material.GRAY_WOOL, Material.BLUE_DYE),
    LIGHT_LAMP(null, Material.REDSTONE_LAMP),
    LIGHT_LANTERN(null, Material.GRAY_WOOL),
    LIGHT_VARIABLE(LightVariant.OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_BLUE(LightVariant.BLUE_OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_GREEN(LightVariant.GREEN_OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_ORANGE(LightVariant.ORANGE_OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_PINK(LightVariant.PINK_OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_PURPLE(LightVariant.PURPLE_OFF.getKey(), Material.GLASS),
    LIGHT_VARIABLE_YELLOW(LightVariant.YELLOW_OFF.getKey(), Material.GLASS),
    LIGHT_BULB_ON(LampVariant.BULB_ON.getKey(), Material.REDSTONE_LAMP),
    LIGHT_CLASSIC_ON(LanternVariant.CLASSIC_ON.getKey(), Material.SEA_LANTERN),
    LIGHT_CLASSIC_OFFSET_ON(LanternVariant.CLASSIC_OFFSET_ON.getKey(), Material.SEA_LANTERN),
    LIGHT_TENTH_ON(LampVariant.TENTH_ON.getKey(), Material.REDSTONE_LAMP),
    LIGHT_ELEVENTH_ON(LampVariant.ELEVENTH_ON.getKey(), Material.REDSTONE_LAMP),
    LIGHT_TWELFTH_ON(LanternVariant.TWELFTH_ON.getKey(), Material.SEA_LANTERN),
    LIGHT_THIRTEENTH_ON(LanternVariant.THIRTEENTH_ON.getKey(), Material.SEA_LANTERN),
    LIGHT_LAMP_ON(LampVariant.LAMP_ON.getKey(), Material.REDSTONE_LAMP),
    LIGHT_LANTERN_ON(null, Material.SEA_LANTERN),
    LIGHT_VARIABLE_ON(LightVariant.VARIABLE.getKey(), Material.GLASS),
    LIGHT_VARIABLE_BLUE_ON(LightVariant.BLUE.getKey(), Material.GLASS),
    LIGHT_VARIABLE_GREEN_ON(LightVariant.GREEN.getKey(), Material.GLASS),
    LIGHT_VARIABLE_ORANGE_ON(LightVariant.ORANGE.getKey(), Material.GLASS),
    LIGHT_VARIABLE_PINK_ON(LightVariant.PINK.getKey(), Material.GLASS),
    LIGHT_VARIABLE_PURPLE_ON(LightVariant.PURPLE.getKey(), Material.GLASS),
    LIGHT_VARIABLE_YELLOW_ON(LightVariant.YELLOW.getKey(), Material.GLASS),
    LIGHT_BULB_CLOISTER(LampVariant.BULB_CLOISTER.getKey(), Material.REDSTONE_LAMP),
    LIGHT_CLASSIC_CLOISTER(LanternVariant.CLASSIC_CLOISTER.getKey(), Material.SEA_LANTERN),
    LIGHT_CLASSIC_OFFSET_CLOISTER(LanternVariant.CLASSIC_OFFSET_CLOISTER.getKey(), Material.SEA_LANTERN),
    LIGHT_TENTH_CLOISTER(LampVariant.TENTH_CLOISTER.getKey(), Material.REDSTONE_LAMP),
    LIGHT_ELEVENTH_CLOISTER(LampVariant.ELEVENTH_CLOISTER.getKey(), Material.REDSTONE_LAMP),
    LIGHT_TWELFTH_CLOISTER(LanternVariant.TWELFTH_CLOISTER.getKey(), Material.SEA_LANTERN),
    LIGHT_THIRTEENTH_CLOISTER(LanternVariant.THIRTEENTH_CLOISTER.getKey(), Material.SEA_LANTERN),
    LIGHT_LAMP_CLOISTER(null, Material.REDSTONE_LAMP),
    LIGHT_LANTERN_CLOISTER(null, Material.SEA_LANTERN),
    LIGHT_VARIABLE_CLOISTER(LightVariant.CLOISTER.getKey(), Material.GLASS),
    CONSOLE_LAMP(null, Material.GLASS, Material.REDSTONE_LAMP),
    NONE(null, null);

    private static final HashMap<String, TARDISDisplayItem> BY_NAME;
    private static final HashMap<Integer, TARDISDisplayItem> BY_MUSHROOM_STEM;
    private static final HashMap<Integer, TARDISDisplayItem> BY_RED_MUSHROOM;
    private final NamespacedKey customModel;
    private final Material material;
    private final Material craftMaterial;

    private TARDISDisplayItem(NamespacedKey customModel, Material item, Material craftMaterial) {
        this.customModel = customModel;
        this.material = item;
        this.craftMaterial = craftMaterial;
    }

    private TARDISDisplayItem(NamespacedKey customModel, Material item) {
        this.customModel = customModel;
        this.material = item;
        this.craftMaterial = null;
    }

    public static TARDISDisplayItem getByModel(NamespacedKey key) {
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            if (tdi.getCustomModel() == null || !key.equals((Object)tdi.getCustomModel())) continue;
            return tdi;
        }
        return null;
    }

    public static TARDISDisplayItem getByDisplayName(Component name) {
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            if (tdi.getCustomModel() == null || !ComponentUtils.stripColour(name).equals(tdi.getDisplayName())) continue;
            return tdi;
        }
        return null;
    }

    public static TARDISDisplayItem getByItemDisplay(ItemDisplay display) {
        ItemStack is = display.getItemStack();
        if (is != null) {
            ItemMeta im = is.getItemMeta();
            if (im.hasItemModel()) {
                return TARDISDisplayItem.getByModel(im.getItemModel());
            }
            if (im.hasDisplayName()) {
                return TARDISDisplayItem.getByDisplayName(im.displayName());
            }
        }
        return null;
    }

    public static HashMap<String, TARDISDisplayItem> getBY_NAME() {
        return BY_NAME;
    }

    public static HashMap<Integer, TARDISDisplayItem> getBY_MUSHROOM_STEM() {
        return BY_MUSHROOM_STEM;
    }

    public static HashMap<Integer, TARDISDisplayItem> getBY_RED_MUSHROOM() {
        return BY_RED_MUSHROOM;
    }

    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public String getDisplayName() {
        return TARDISStringUtils.capitalise(this.getName());
    }

    public NamespacedKey getCustomModel() {
        return this.customModel;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Material getCraftMaterial() {
        return this.craftMaterial;
    }

    public boolean isLight() {
        switch (this.ordinal()) {
            case 55: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    public boolean isLit() {
        switch (this.ordinal()) {
            case 55: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    public boolean isVariable() {
        switch (this.ordinal()) {
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isSeed() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public boolean isDoor() {
        switch (this.ordinal()) {
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return true;
            }
        }
        return false;
    }

    static {
        BY_NAME = new HashMap();
        BY_MUSHROOM_STEM = new HashMap<Integer, TARDISDisplayItem>(){
            {
                this.put(1, BLUE_LAMP);
                this.put(2, RED_LAMP);
                this.put(3, PURPLE_LAMP);
                this.put(4, GREEN_LAMP);
                this.put(10000001, BLUE_LAMP_ON);
                this.put(10000002, RED_LAMP_ON);
                this.put(10000003, PURPLE_LAMP_ON);
                this.put(10000004, GREEN_LAMP_ON);
                this.put(46, HEXAGON);
                this.put(47, ROUNDEL);
                this.put(48, ROUNDEL_OFFSET);
                this.put(49, COG);
                this.put(5, HEAT_BLOCK);
                this.put(50, ADVANCED_CONSOLE);
                this.put(51, DISK_STORAGE);
                this.put(54, BLUE_BOX);
            }
        };
        BY_RED_MUSHROOM = new HashMap<Integer, TARDISDisplayItem>(){
            {
                this.put(40, CREATIVE);
                this.put(41, COMPOUND);
                this.put(42, REDUCER);
                this.put(43, CONSTRUCTOR);
                this.put(44, LAB);
                this.put(45, PRODUCT);
            }
        };
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            BY_NAME.put(tdi.toString().toLowerCase(Locale.ROOT), tdi);
        }
    }
}

