/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;
import org.bukkit.World;

public class ResultSetCurrentFromId {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String prefix;
    private Current current = null;

    public ResultSetCurrentFromId(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        World world;
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "current WHERE tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    world = TARDISAliasResolver.getWorldFromAlias(rs.getString("world"));
                    int x = rs.getInt("x");
                    int y = rs.getInt("y");
                    int z = rs.getInt("z");
                    COMPASS direction = COMPASS.valueOf(rs.getString("direction"));
                    boolean submarine = rs.getBoolean("submarine");
                    this.current = new Current(new Location(world, (double)x, (double)y, (double)z), direction, submarine);
                    break block16;
                }
                boolean x = false;
                return x;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for current from id table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing current from id table! " + e.getMessage());
                }
            }
        }
        return world != null;
    }

    public Current getCurrent() {
        return this.current;
    }
}

