/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.control.actions.ConsoleLampAction;
import me.eccentric_nz.TARDIS.control.actions.LightLevelAction;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.lights.TARDISLightLevelsInventory;
import me.eccentric_nz.TARDIS.lights.TARDISLightsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISLightLevelsGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISLightLevelsGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightLevelsMenuClick(InventoryClickEvent event) {
        InventoryView view;
        ItemStack is;
        if (!(event.getInventory().getHolder(false) instanceof TARDISLightLevelsInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot >= 0 && slot < 54 && (is = (view = event.getView()).getItem(slot)) != null) {
            int id = -1;
            ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
            if (rst.fromUUID(uuid.toString())) {
                id = rst.getTardisId();
            }
            switch (slot) {
                case 9: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 10, false);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 10, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 50, id);
                    break;
                }
                case 11: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 10, true);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 10, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 50, id);
                    break;
                }
                case 15: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 16, false);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 16, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 49, id);
                    break;
                }
                case 17: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 16, true);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 16, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 49, id);
                    break;
                }
                case 30: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 31, false);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 31, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 56, id);
                    break;
                }
                case 32: {
                    Pair<Boolean, Integer> setLevel = this.getNewState(view, 31, true);
                    if (!((Boolean)setLevel.getFirst()).booleanValue()) break;
                    this.setState(view, 31, (Integer)setLevel.getSecond());
                    this.setLightLevel((Integer)setLevel.getSecond(), 56, id);
                    break;
                }
                case 45: {
                    player.openInventory(new TARDISLightsInventory(this.plugin, id, uuid).getInventory());
                    break;
                }
                case 53: {
                    this.close(player);
                }
            }
        }
    }

    private Pair<Boolean, Integer> getNewState(InventoryView view, int slot, boolean next) {
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        String lore = ComponentUtils.stripColour((Component)im.lore().getFirst());
        int state = TARDISNumberParsers.parseInt(lore);
        if (slot == 16) {
            int index = ArrayUtils.indexOf((int[])LightLevel.exterior_level, (int)state);
            if (next && index - 1 >= 0) {
                return new Pair((Object)true, (Object)LightLevel.exterior_level[index - 1]);
            }
            if (index + 1 < LightLevel.exterior_level.length) {
                return new Pair((Object)true, (Object)LightLevel.exterior_level[index + 1]);
            }
        } else {
            int index = ArrayUtils.indexOf((int[])LightLevel.interior_level, (int)state);
            if (next && index - 1 >= 0) {
                return new Pair((Object)true, (Object)LightLevel.interior_level[index - 1]);
            }
            if (index + 1 < LightLevel.interior_level.length) {
                return new Pair((Object)true, (Object)LightLevel.interior_level[index + 1]);
            }
        }
        return new Pair((Object)false, (Object)state);
    }

    private void setState(InventoryView view, int slot, int level) {
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        lore.set(0, Component.text((int)level));
        im.lore(lore);
        is.setItemMeta(im);
    }

    private void setLightLevel(int setLevel, int which, int id) {
        ResultSetLightLevel rs = new ResultSetLightLevel(this.plugin);
        if (rs.fromTypeAndID(which, id)) {
            if (which > 50) {
                new ConsoleLampAction(this.plugin).illuminate(id, setLevel, rs.getControlId());
            } else {
                new LightLevelAction(this.plugin).illuminate(setLevel - 1, rs.getControlId(), rs.isPowered(), which, rs.isPoliceBox(), id, rs.isLightsOn());
            }
        }
    }
}

