/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.portal;

import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class MatrixUtils {
    public static BlockData[][][] rotateToWest(BlockData[][][] capture) {
        int layers = capture.length;
        int sizeR = capture[0].length;
        int sizeC = capture[0][0].length;
        BlockData[][][] rotated = new BlockData[layers][sizeC][sizeR];
        for (int l = 0; l < layers; ++l) {
            BlockData[][] data = new BlockData[sizeC][sizeR];
            for (int r = 0; r < sizeR; ++r) {
                for (int c = 0; c < sizeC; ++c) {
                    BlockData blockData = capture[l][r][c];
                    if (blockData instanceof Directional) {
                        Directional directional = (Directional)blockData;
                        directional.setFacing(switch (directional.getFacing()) {
                            case BlockFace.EAST -> BlockFace.SOUTH;
                            case BlockFace.SOUTH -> BlockFace.WEST;
                            case BlockFace.WEST -> BlockFace.NORTH;
                            default -> BlockFace.EAST;
                        });
                        data[sizeC - 1 - c][r] = directional;
                        continue;
                    }
                    data[sizeC - 1 - c][r] = blockData;
                }
            }
            rotated[l] = data;
        }
        return rotated;
    }

    public static BlockData[][][] rotateToEast(BlockData[][][] capture) {
        int layers = capture.length;
        int sizeR = capture[0].length;
        int sizeC = capture[0][0].length;
        BlockData[][][] rotated = new BlockData[layers][sizeC][sizeR];
        for (int l = 0; l < layers; ++l) {
            BlockData[][] data = new BlockData[sizeC][sizeR];
            for (int r = 0; r < sizeR; ++r) {
                for (int c = 0; c < sizeC; ++c) {
                    BlockData blockData = capture[l][r][c];
                    if (blockData instanceof Directional) {
                        Directional directional = (Directional)blockData;
                        directional.setFacing(switch (directional.getFacing()) {
                            case BlockFace.EAST -> BlockFace.NORTH;
                            case BlockFace.SOUTH -> BlockFace.EAST;
                            case BlockFace.WEST -> BlockFace.SOUTH;
                            default -> BlockFace.WEST;
                        });
                        data[c][sizeR - 1 - r] = directional;
                        continue;
                    }
                    data[c][sizeR - 1 - r] = blockData;
                }
            }
            rotated[l] = data;
        }
        return rotated;
    }

    public static BlockData[][][] rotateToNorth(BlockData[][][] capture) {
        int layers = capture.length;
        int sizeR = capture[0].length;
        int sizeC = capture[0][0].length;
        BlockData[][][] rotated = new BlockData[layers][sizeR][sizeC];
        for (int l = 0; l < layers; ++l) {
            BlockData[][] data = new BlockData[sizeR][sizeC];
            for (int r = 0; r < sizeR; ++r) {
                for (int c = 0; c < sizeC; ++c) {
                    BlockData blockData = capture[l][sizeR - 1 - r][c];
                    if (blockData instanceof Directional) {
                        Directional directional = (Directional)blockData;
                        directional.setFacing(directional.getFacing().getOppositeFace());
                        data[r][sizeC - 1 - c] = directional;
                        continue;
                    }
                    data[r][sizeC - 1 - c] = blockData;
                }
            }
            rotated[l] = data;
        }
        return rotated;
    }

    public static double getPlayerAngle(double vx, double vz, double px, double pz, double dx, double dz) {
        double angle1 = Math.atan2(vz - dz, vx - dx);
        double angle2 = Math.atan2(pz - dz, px - dx);
        return Math.toDegrees(angle1 - angle2);
    }
}

