/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.sudo;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.messaging.TARDISUpdateLister;
import me.eccentric_nz.TARDIS.monitor.MonitorUtils;
import me.eccentric_nz.TARDIS.rotors.TARDISTimeRotor;
import me.eccentric_nz.TARDIS.update.TARDISUpdateableChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class SudoUpdate {
    private final TARDIS plugin;

    SudoUpdate(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean initiate(Player player, String[] args, int id, UUID uuid) {
        Updateable updateable;
        if (args.length < 3) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        String tardis_block = TARDISStringUtils.toScoredUppercase(args[2]);
        try {
            updateable = Updateable.valueOf(tardis_block);
        }
        catch (IllegalArgumentException e) {
            new TARDISUpdateLister(this.plugin, player).list();
            return true;
        }
        if (updateable.equals((Object)Updateable.SIEGE) && !this.plugin.getConfig().getBoolean("siege.enabled")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_DISABLED");
            return true;
        }
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (rs.resultSet()) {
            Block block;
            Tardis tardis = rs.getTardis();
            if (updateable.equals((Object)Updateable.HINGE)) {
                Block block2 = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 10);
                if (block2.getType().equals((Object)Material.IRON_DOOR)) {
                    Door door = (Door)block2.getBlockData();
                    if (args.length == 3) {
                        Door.Hinge setHinge = Door.Hinge.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                        door.setHinge(setHinge);
                    } else {
                        Door.Hinge hinge = door.getHinge();
                        if (hinge.equals((Object)Door.Hinge.LEFT)) {
                            door.setHinge(Door.Hinge.RIGHT);
                        } else {
                            door.setHinge(Door.Hinge.LEFT);
                        }
                    }
                    block2.setBlockData((BlockData)door);
                }
                return true;
            }
            if (updateable.equals((Object)Updateable.STORAGE) && ((block = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 10)).getType().equals((Object)Material.NOTE_BLOCK) || block.getType().equals((Object)Material.MUSHROOM_STEM))) {
                block.setBlockData(TARDISConstants.BARRIER, true);
                TARDISDisplayItemUtils.set(TARDISDisplayItem.DISK_STORAGE, block, id);
            }
            if (new TARDISUpdateableChecker(this.plugin, updateable, player, tardis, tardis_block).canUpdate()) {
                if ((updateable.equals((Object)Updateable.ROTOR) || updateable.equals((Object)Updateable.MONITOR) || updateable.equals((Object)Updateable.MONITOR_FRAME)) && args.length == 4 && args[3].equalsIgnoreCase("unlock")) {
                    ItemFrame itemFrame = null;
                    switch (updateable) {
                        case ROTOR: {
                            itemFrame = TARDISTimeRotor.getItemFrame(tardis.getRotor());
                            break;
                        }
                        case MONITOR: {
                            itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), true);
                            break;
                        }
                        case MONITOR_FRAME: {
                            itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), false);
                            ItemStack glass = itemFrame.getItem();
                            ItemMeta im = glass.getItemMeta();
                            im.displayName((Component)ComponentUtils.toWhite("Monitor Frame"));
                            glass.setItemMeta(im);
                            break;
                        }
                    }
                    if (itemFrame != null) {
                        TARDISTimeRotor.unlockItemFrame(itemFrame);
                        this.plugin.getGeneralKeeper().getTimeRotors().remove(itemFrame.getUniqueId());
                        Block block3 = itemFrame.getLocation().getBlock();
                        String location = block3.getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().remove(location);
                        String under = block3.getRelative(BlockFace.DOWN).getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().remove(under);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROTOR_UNFIXED");
                    }
                    return true;
                }
                TARDISSudoTracker.SUDOERS.put(player.getUniqueId(), uuid);
                this.plugin.getTrackerKeeper().getUpdatePlayers().put(player.getUniqueId(), tardis_block);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_CLICK", tardis_block);
                if (updateable.equals((Object)Updateable.DIRECTION)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HOOK_REMIND");
                }
            }
        }
        return true;
    }
}

