/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

import java.util.List;

public enum RepeaterControl {
    WORLD(2, List.of("Current world", "Normal world", "Nether world", "End world")),
    X(3, List.of("1x X-distance", "2x X-distance", "3x X-distance", "4x X-distance")),
    Z(4, List.of("1x Z-distance", "2x Z-distance", "3x Z-distance", "4x Z-distance")),
    MULTIPLIER(5, List.of("1x multiplier", "2x multiplier", "3x multiplier", "4x multiplier"));

    private final int control;
    private final List<String> descriptions;

    private RepeaterControl(int control, List<String> descriptions) {
        this.control = control;
        this.descriptions = descriptions;
    }

    public static RepeaterControl getControl(int c) {
        return switch (c) {
            case 2 -> WORLD;
            case 3 -> X;
            case 4 -> Z;
            default -> MULTIPLIER;
        };
    }

    public int getControl() {
        return this.control;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }
}

