/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISBiomeReaderListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISBiomeFinder;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TARDISTravelBiome {
    private final TARDIS plugin;

    public TARDISTravelBiome(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, String[] args, int id) {
        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.biome")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_BIOME");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.TELEPATHIC_CIRCUIT)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
            TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (!tcc.hasTelepathic()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
                return true;
            }
        }
        String upper = args[1].toUpperCase(Locale.ROOT);
        if (this.plugin.getConfig().getBoolean("difficulty.disks") && !this.plugin.getUtils().inGracePeriod(player, false) && !upper.equals("LIST")) {
            if (this.plugin.getConfig().getBoolean("difficulty.biome_reader")) {
                boolean hasBiomeDisk = false;
                UUID uuid = player.getUniqueId();
                HashMap<String, Object> whereb = new HashMap<String, Object>();
                whereb.put("uuid", uuid.toString());
                ResultSetDiskStorage rsb = new ResultSetDiskStorage(this.plugin, whereb);
                if (rsb.resultSet()) {
                    try {
                        ItemStack[] disks1 = TARDISSerializeInventory.itemStacksFromString(rsb.getBiomesOne());
                        if (TARDISBiomeReaderListener.hasBiomeDisk(disks1, upper)) {
                            hasBiomeDisk = true;
                        } else {
                            ItemStack[] disks2 = TARDISSerializeInventory.itemStacksFromString(rsb.getBiomesTwo());
                            if (TARDISBiomeReaderListener.hasBiomeDisk(disks2, upper)) {
                                hasBiomeDisk = true;
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.plugin.debug("Could not deserialize inventory!");
                    }
                }
                if (!hasBiomeDisk) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_DISK_NOT_FOUND");
                    return true;
                }
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ADV_BIOME");
                return true;
            }
        }
        if (upper.equals("LIST")) {
            StringBuilder buf = new StringBuilder();
            for (Biome bi : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
                if (bi.equals((Object)Biome.THE_VOID)) continue;
                buf.append(bi).append(", ");
            }
            String b = buf.substring(0, buf.length() - 2);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOMES", b);
        } else {
            World w;
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            Current current = rsc.getCurrent();
            if (args.length > 2) {
                if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_FROM_VORTEX");
                    return true;
                }
                planet = args[2].toLowerCase(Locale.ROOT);
                if (TARDISConstants.isTARDISPlanet(planet)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_PLANET", args[2]);
                    return true;
                }
                w = TARDISAliasResolver.getWorldFromAlias(args[2]);
                if (w == null) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_DELETED", args[2]);
                    return true;
                }
            } else {
                planet = current.location().getWorld().getName();
                if (TARDISConstants.isTARDISPlanet(planet)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_NOT_PLANET", current.location().getWorld().getName());
                    return true;
                }
                w = current.location().getWorld();
            }
            new TARDISBiomeFinder(this.plugin).run(w, upper, player, id, current.direction(), current.location());
        }
        return true;
    }
}

