/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import com.mojang.datafixers.util.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ResultSetOccupiedScreen {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final List<Pair<Integer, UUID>> data = new ArrayList<Pair<Integer, UUID>>();
    private final String prefix;

    public ResultSetOccupiedScreen(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void resultSetAsync(ResultSetOccupiedCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.resultSet();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSet() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            long time = System.currentTimeMillis() - 86400000L;
            String query = "SELECT DISTINCT " + this.prefix + "travellers.tardis_id, " + this.prefix + "interactions.uuid FROM " + this.prefix + "travellers, " + this.prefix + "tardis, " + this.prefix + "interactions WHERE " + this.prefix + "interactions.control = 'SCREEN' AND " + this.prefix + "tardis.lastuse > " + time + " AND " + this.prefix + "tardis.tardis_id = " + this.prefix + "travellers.tardis_id  AND " + this.prefix + "tardis.tardis_id = " + this.prefix + "interactions.tardis_id";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.createStatement();
                rs = statement.executeQuery(query);
                if (!rs.isBeforeFirst()) break block16;
                while (rs.next()) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(rs.getString("uuid"));
                    }
                    catch (IllegalArgumentException e) {
                        uuid = TARDISStaticUtils.getZERO_UUID();
                    }
                    Pair pair = new Pair((Object)rs.getInt("tardis_id"), (Object)uuid);
                    this.data.add((Pair<Integer, UUID>)pair);
                }
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for ResultSetOccupiedScreen! " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing ResultSetOccupiedScreen! " + e.getMessage());
                }
            }
        }
    }

    public List<Pair<Integer, UUID>> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public static interface ResultSetOccupiedCallback {
        public void onDone(ResultSetOccupiedScreen var1);
    }
}

