/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.telepathic.EnvironmentBiomes;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateBiomes;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateBiomesForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;

    public FloodgateBiomesForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("Telepathic Biome Finder");
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
        if (rsc.resultSet()) {
            World.Environment environment = rsc.getCurrent().location().getWorld().getEnvironment();
            for (Biome biome : switch (environment) {
                case World.Environment.NETHER -> EnvironmentBiomes.NETHER;
                case World.Environment.THE_END -> EnvironmentBiomes.END;
                default -> EnvironmentBiomes.OVERWORLD;
            }) {
                String path = FloodgateBiomes.BIOME_BLOCKS.get(biome);
                builder.button(TARDISStringUtils.capitalise(biome.toString()), FormImage.Type.PATH, String.format("textures/%s", path));
            }
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        int travel;
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
        if (!rs.fromID(this.id)) {
            return;
        }
        int level = rs.getArtronLevel();
        if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        String enumStr = TARDISStringUtils.toEnumUppercase(response.clickedButton().text());
        player.performCommand("tardistravel biome " + enumStr);
    }
}

