/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.gui;

import java.util.ArrayList;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetWarpByName;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMSavesGUI;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TVMSavesGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    int selectedSlot = -1;

    public TVMSavesGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onGUIClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TVMSavesGUI)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        if (view.getItem(slot) == null) {
            return;
        }
        switch (slot) {
            case 45: {
                break;
            }
            case 46: {
                this.close(player);
                break;
            }
            case 48: {
                this.doPrev(view, player);
                break;
            }
            case 49: {
                this.doNext(view, player);
                break;
            }
            case 51: {
                this.delete(view, player);
                break;
            }
            case 53: {
                this.doWarp(view, player);
                break;
            }
            default: {
                this.selectedSlot = slot;
            }
        }
    }

    private void doPrev(InventoryView view, Player player) {
        int page = this.getPageNumber(view);
        if (page > 1) {
            int start = page * 44 - 44;
            this.close(player);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMSavesGUI(this.plugin, start, start + 44, player.getUniqueId().toString()).getInventory()), 2L);
        }
    }

    private void doNext(InventoryView view, Player player) {
        int page = this.getPageNumber(view);
        int start = page * 44 + 44;
        this.close(player);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMSavesGUI(this.plugin, start, start + 44, player.getUniqueId().toString()).getInventory()), 2L);
    }

    private void delete(InventoryView view, Player player) {
        if (this.selectedSlot != -1) {
            ItemStack is = view.getItem(this.selectedSlot);
            ItemMeta im = is.getItemMeta();
            String save_name = ComponentUtils.stripColour(im.displayName());
            TVMResultSetWarpByName rss = new TVMResultSetWarpByName(this.plugin, player.getUniqueId().toString(), save_name);
            if (rss.resultSet()) {
                this.close(player);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("save_id", rss.getId());
                this.plugin.getQueryFactory().doDelete("saves", where);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SAVE_DELETED");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SELECT");
        }
    }

    private void doWarp(InventoryView view, Player player) {
        if (this.selectedSlot != -1) {
            ItemStack is = view.getItem(this.selectedSlot);
            ItemMeta im = is.getItemMeta();
            String save_name = ComponentUtils.stripColour(im.displayName());
            TVMResultSetWarpByName rss = new TVMResultSetWarpByName(this.plugin, player.getUniqueId().toString(), save_name);
            if (rss.resultSet()) {
                this.close(player);
                ArrayList<Player> players = new ArrayList<Player>();
                players.add(player);
                if (this.plugin.getVortexConfig().getBoolean("allow.multiple")) {
                    player.getNearbyEntities(0.5, 0.5, 0.5).forEach(e -> {
                        if (e instanceof Player && !e.getUniqueId().equals(player.getUniqueId())) {
                            players.add((Player)e);
                        }
                    });
                }
                int required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.saved") * players.size();
                if (!TVMUtils.checkTachyonLevel(player.getUniqueId().toString(), required)) {
                    this.close(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_REQUIRED", required);
                    return;
                }
                Location l = rss.getWarp();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_STANDBY");
                while (!l.getChunk().isLoaded()) {
                    l.getChunk().load();
                }
                TVMUtils.movePlayers(players, l, player.getLocation().getWorld());
                new TVMQueryFactory(this.plugin).alterTachyons(player.getUniqueId().toString(), -required);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SELECT");
        }
    }
}

