/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Area;

public class ResultSetAreas {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final boolean onlynames;
    private final List<Area> data = new ArrayList<Area>();
    private final List<String> names = new ArrayList<String>();
    private final String prefix;
    private Area area;

    public ResultSetAreas(TARDIS plugin, HashMap<String, Object> where, boolean multiple, boolean onlynames) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.onlynames = onlynames;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block23: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "areas" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (!this.onlynames) {
                            this.area = new Area(rs.getInt("area_id"), rs.getString("area_name"), rs.getString("world"), rs.getInt("minx"), rs.getInt("minz"), rs.getInt("maxx"), rs.getInt("maxz"), rs.getInt("y"), rs.getInt("parking_distance"), rs.getString("invisibility"), rs.getString("direction"), rs.getBoolean("grid"));
                            if (!this.multiple) continue;
                            this.data.add(this.area);
                            continue;
                        }
                        this.names.add(rs.getString("area_name"));
                    }
                    break block23;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for areas table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing areas table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Area getArea() {
        return this.area;
    }

    public List<Area> getData() {
        return this.data;
    }

    public List<String> getNames() {
        return this.names;
    }
}

