/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetChunkContainsTARDIS {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String world;
    private final int minX;
    private final int minZ;
    private final String prefix;

    public ResultSetChunkContainsTARDIS(TARDIS plugin, String world, int minX, int minZ) {
        this.plugin = plugin;
        this.world = world;
        this.minX = minX;
        this.minZ = minZ;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT tardis_id FROM " + this.prefix + "current WHERE world = ?AND x >= ? AND x < ? AND z >= ? AND z < ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, this.world);
            statement.setInt(2, this.minX);
            statement.setInt(3, this.minZ);
            statement.setInt(4, this.minX + 16);
            statement.setInt(5, this.minZ + 16);
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for [ChunkContains] current table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing [ChunkContains] current table! " + e.getMessage());
            }
        }
    }
}

