/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetDiskStorage {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String prefix;
    private String savesOne;
    private String savesTwo;
    private String areas;
    private String players;
    private String biomesOne;
    private String biomesTwo;
    private String presetsOne;
    private String presetsTwo;
    private String circuits;
    private String console;
    private String versions;

    public ResultSetDiskStorage(TARDIS plugin, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block32: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "storage" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        this.savesOne = rs.getString("saves_one");
                        if (rs.wasNull()) {
                            this.savesOne = "";
                        }
                        this.savesTwo = rs.getString("saves_two");
                        if (rs.wasNull()) {
                            this.savesTwo = "";
                        }
                        this.areas = rs.getString("areas");
                        if (rs.wasNull()) {
                            this.areas = "";
                        }
                        this.players = rs.getString("players");
                        if (rs.wasNull()) {
                            this.players = "";
                        }
                        this.biomesOne = rs.getString("biomes_one");
                        if (rs.wasNull()) {
                            this.biomesOne = "";
                        }
                        this.biomesTwo = rs.getString("biomes_two");
                        if (rs.wasNull()) {
                            this.biomesTwo = "";
                        }
                        this.presetsOne = rs.getString("presets_one");
                        if (rs.wasNull()) {
                            this.presetsOne = "";
                        }
                        this.presetsTwo = rs.getString("presets_two");
                        if (rs.wasNull()) {
                            this.presetsTwo = "";
                        }
                        this.circuits = rs.getString("circuits");
                        if (rs.wasNull()) {
                            this.circuits = "";
                        }
                        this.console = rs.getString("console");
                        if (rs.wasNull() || this.console.isEmpty()) {
                            this.console = "rO0ABXcEAAAAEnBwcHBwcHBwcHBwcHBwcHBwcA==";
                        }
                        this.versions = rs.getString("versions");
                        if (!rs.wasNull()) continue;
                        this.versions = "0,0,0,0,0,0,0,0,0";
                    }
                    break block32;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for storage table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing storage table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public String getSavesOne() {
        return this.savesOne;
    }

    public String getSavesTwo() {
        return this.savesTwo;
    }

    public String getAreas() {
        return this.areas;
    }

    public String getPlayers() {
        return this.players;
    }

    public String getBiomesOne() {
        return this.biomesOne;
    }

    public String getBiomesTwo() {
        return this.biomesTwo;
    }

    public String getPresetsOne() {
        return this.presetsOne;
    }

    public String getPresetsTwo() {
        return this.presetsTwo;
    }

    public String getCircuits() {
        return this.circuits;
    }

    public String getConsole() {
        return this.console;
    }

    public String getVersions() {
        return this.versions;
    }
}

