/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Planet;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Material;
import org.bukkit.World;

public class ResultSetPlanets {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final List<Planet> data = new ArrayList<Planet>();
    private final String prefix;
    private final int id;

    public ResultSetPlanets(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block19: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT DISTINCT world FROM " + this.prefix + "destinations WHERE tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        Material material;
                        String planet = rs.getString("world");
                        World world = this.plugin.getServer().getWorld(planet);
                        if (world == null) continue;
                        String alias = TARDISAliasResolver.getWorldAlias(world);
                        try {
                            String m = this.plugin.getPlanetsConfig().getString("planets." + planet + ".icon");
                            material = m != null ? Material.valueOf((String)m) : this.getIcon(world.getEnvironment());
                        }
                        catch (IllegalArgumentException e) {
                            material = this.getIcon(world.getEnvironment());
                        }
                        this.data.add(new Planet(alias, material));
                    }
                    break block19;
                }
                boolean planet = false;
                return planet;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for destinations table when getting dimensions! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing destinations table when getting dimensions! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<Planet> getData() {
        Collections.sort(this.data);
        return this.data;
    }

    private Material getIcon(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> Material.NETHERRACK;
            case World.Environment.THE_END -> Material.END_STONE;
            default -> Material.STONE;
        };
    }
}

