/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISDesktopThemeEvent;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeRunnable;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TARDISWallFloorRunnable
extends TARDISThemeRunnable {
    private final TARDIS plugin;
    private final UUID uuid;
    private final TARDISUpgradeData tud;
    private boolean running;
    private int level = 0;
    private int row = 0;
    private int h;
    private int w;
    private int c;
    private int startx;
    private int starty;
    private int startz;
    private World world;
    private JsonArray arr;
    private Material wall_type;
    private Material floor_type;
    private Player player;

    public TARDISWallFloorRunnable(TARDIS plugin, UUID uuid, TARDISUpgradeData tud) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.tud = tud;
    }

    @Override
    public void run() {
        if (!this.running) {
            Tardis tardis;
            int slot;
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", this.tud.getSchematic().getPermission(), this.tud.getSchematic().isCustom());
            if (obj == null) {
                return;
            }
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt();
            this.w = dimensions.get("width").getAsInt();
            this.c = dimensions.get("length").getAsInt();
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", this.uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
            if (!rs.resultSet()) {
                HashMap<String, Object> wherea = new HashMap<String, Object>();
                wherea.put("uuid", this.uuid.toString());
                int amount = this.plugin.getArtronConfig().getInt("upgrades." + this.tud.getSchematic().getPermission());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, wherea, this.player);
            }
            if ((slot = (tardis = rs.getTardis()).getTIPS()) != -1000001) {
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TARDISTIPSData pos = tintpos.getTIPSData(slot);
                this.startx = pos.getCentreX();
                this.startz = pos.getCentreZ();
            } else {
                int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                this.startx = gsl[0];
                this.startz = gsl[2];
            }
            this.starty = this.tud.getSchematic().getStartY();
            this.world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            this.wall_type = Material.valueOf((String)this.tud.getWall());
            this.floor_type = Material.valueOf((String)this.tud.getFloor());
            this.arr = obj.get("input").getAsJsonArray();
            this.running = true;
            this.player = this.plugin.getServer().getPlayer(this.uuid);
            this.plugin.getPM().callEvent((Event)new TARDISDesktopThemeEvent(this.player, tardis, this.tud));
            this.plugin.getTrackerKeeper().getUpgrades().remove(this.uuid);
        }
        if (this.level == this.h - 1 && this.row == this.w - 1) {
            this.plugin.getServer().getScheduler().cancelTask(this.taskID);
            this.taskID = 0;
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPGRADE_FINISHED");
        } else {
            JsonArray floor = this.arr.get(this.level).getAsJsonArray();
            JsonArray r = (JsonArray)floor.get(this.row);
            for (int col = 0; col < this.c; ++col) {
                JsonObject bb = r.get(col).getAsJsonObject();
                int x = this.startx + this.row;
                int y = this.starty + this.level;
                int z = this.startz + col;
                BlockData data = this.plugin.getServer().createBlockData(bb.get("data").getAsString());
                Material type = data.getMaterial();
                if (type.equals((Object)Material.ORANGE_WOOL)) {
                    if (this.wall_type == Material.ORANGE_WOOL) {
                        if (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                            data = TARDISConstants.BARRIER;
                            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, this.world, x, y, z);
                        }
                    } else {
                        data = this.wall_type.createBlockData();
                    }
                    TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                }
                if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                    type = this.floor_type;
                    TARDISBlockSetters.setBlock(this.world, x, y, z, type);
                }
                if (!type.equals((Object)Material.BLUE_WOOL)) continue;
                if (!TARDISFloodgate.isFloodgateEnabled() || !TARDISFloodgate.isBedrockPlayer(this.player.getUniqueId())) {
                    data = TARDISConstants.BARRIER;
                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.BLUE_BOX, this.world, x, y, z);
                }
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
            }
            if (this.row < this.w) {
                ++this.row;
            }
            if (this.row == this.w && this.level < this.h) {
                this.row = 0;
                ++this.level;
            }
        }
    }
}

