/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic;

import java.io.File;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.actions.CSVPaster;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicClear;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicConvert;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicFlowers;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicLavaAndWater;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicLoad;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicPaster;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicRemoveLights;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicReplace;
import me.eccentric_nz.TARDIS.schematic.actions.SchematicSave;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISSchematicCommand
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISSchematicCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisschematic")) {
            if (args.length < 1) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return true;
            }
            if (!player.hasPermission("tardis.admin")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
                return true;
            }
            if (args[0].equalsIgnoreCase("paste")) {
                boolean noAir = args.length == 2 && args[1].equalsIgnoreCase("no_air");
                SchematicPaster paster = new SchematicPaster(this.plugin, player, !noAir);
                int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)paster, 1L, 3L);
                paster.setTask(task);
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("pastecsv")) {
                Location eyeLocation = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getLocation();
                String path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + "legacy_budget.csv";
                File csv = new File(path);
                if (csv.exists()) {
                    CSVPaster paster = new CSVPaster(this.plugin);
                    paster.buildLegacy(paster.arrayFromCSV(csv), eyeLocation);
                } else {
                    this.plugin.getMessenger().message((CommandSender)player, "Nice try, but it looks like you don't know what this command is for...");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("clear")) {
                return new SchematicClear().act(this.plugin, player);
            }
            if (args[0].equalsIgnoreCase("remove")) {
                return new SchematicRemoveLights().act(this.plugin, player);
            }
            if (args[0].equalsIgnoreCase("flowers")) {
                return new SchematicFlowers().act(this.plugin, player);
            }
            if (args[0].equalsIgnoreCase("fixliquid")) {
                return new SchematicLavaAndWater().act(this.plugin, player, "lava".equals(args[1].toLowerCase(Locale.ROOT)));
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NAME");
                return true;
            }
            if (args[0].equalsIgnoreCase("save")) {
                return new SchematicSave().act(this.plugin, player, args[1]);
            }
            if (args[0].equalsIgnoreCase("replace")) {
                return new SchematicReplace().act(this.plugin, player, args);
            }
            if (args[0].equalsIgnoreCase("convert")) {
                return new SchematicConvert().act(this.plugin, player, args);
            }
            if (args[0].equalsIgnoreCase("load")) {
                return new SchematicLoad().act(this.plugin, player, args);
            }
        }
        return false;
    }
}

