/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.logging;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.tardischunkgenerator.logging.TextUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;

public class TARDISLogFilter
implements Filter {
    private final String path;
    private final List<String> filters = new ArrayList<String>();
    private boolean clean = true;

    public TARDISLogFilter(String path) {
        this.path = path;
        this.filters.add("TARDIS");
        this.filters.add("tardis");
        this.filters.add("me.eccentric_nz");
        this.filters.add("Caused by:");
        this.filters.add("Vortex Manipulator");
        this.filters.add("Handles");
        this.filters.add("Weeping Angels");
        this.filters.add("Sonic Blaster");
    }

    public Filter.Result checkMessage(String message) {
        for (String filter : this.filters) {
            if (!message.contains(filter)) continue;
            this.writeToFile(message.replaceAll("\u001b\\[[;\\d]*m", ""));
            break;
        }
        return Filter.Result.NEUTRAL;
    }

    private void writeToFile(String message) {
        try {
            FileWriter fileWriter;
            if (this.clean) {
                fileWriter = new FileWriter(this.path);
                this.clean = false;
            } else {
                fileWriter = new FileWriter(this.path, true);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(message);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Filter.Result getOnMismatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result getOnMatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object ... objects) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        return this.checkMessage(s);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object o, Throwable throwable) {
        return this.checkMessage(TextUtils.getStacktrace(throwable, true, "me.eccentric_nz."));
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.checkMessage(TextUtils.getStacktrace(throwable, true, "me.eccentric_nz."));
    }

    public Filter.Result filter(LogEvent logEvent) {
        if (logEvent.getThrown() != null) {
            return this.checkMessage(TextUtils.getStacktrace(logEvent.getThrown(), true, "me.eccentric_nz."));
        }
        return this.checkMessage(logEvent.getMessage().getFormattedMessage());
    }

    public LifeCycle.State getState() {
        try {
            return LifeCycle.State.STARTED;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void initialize() {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStopped() {
        return false;
    }
}

