/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen;

import java.util.List;
import java.util.Random;
import me.eccentric_nz.tardischunkgenerator.worldgen.biomeproviders.WaterBiomeProvider;
import me.eccentric_nz.tardischunkgenerator.worldgen.populators.IslandBlockPopulator;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class WaterGenerator
extends ChunkGenerator {
    public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        SimplexOctaveGenerator generator = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()), 6);
        generator.setScale(0.008);
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double noise = generator.noise((double)(worldX + x), (double)(worldZ + z), 1.0, 1.0, true);
                int height = (int)(noise * 40.0);
                if ((height += 64) > chunkData.getMaxHeight()) {
                    height = chunkData.getMaxHeight();
                }
                for (int y = chunkData.getMinHeight(); y < height; ++y) {
                    if (y <= height - 12) {
                        chunkData.setBlock(x, y, z, Material.STONE);
                        continue;
                    }
                    chunkData.setBlock(x, y, z, Material.SAND);
                }
            }
        }
    }

    public void generateSurface(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 23; y < 96; ++y) {
                    if (!chunkData.getType(x, y, z).isAir()) continue;
                    chunkData.setBlock(x, y, z, Material.WATER);
                }
            }
        }
    }

    public void generateBedrock(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        if (chunkData.getMinHeight() == worldInfo.getMinHeight()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    chunkData.setBlock(x, chunkData.getMinHeight(), z, Material.BEDROCK);
                }
            }
        }
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return new WaterBiomeProvider();
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        List populators = super.getDefaultPopulators(world);
        populators.add(new IslandBlockPopulator());
        return populators;
    }
}

