/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.TARDISArchPersister;
import me.eccentric_nz.TARDIS.builders.utility.TARDISSeedBlockPersister;
import me.eccentric_nz.TARDIS.camera.CameraPersister;
import me.eccentric_nz.TARDIS.database.TARDISTimeRotorLoader;
import me.eccentric_nz.TARDIS.desktop.TARDISPreviewPersister;
import me.eccentric_nz.TARDIS.flight.FlightPersister;
import me.eccentric_nz.TARDIS.flight.TARDISVortexPersister;
import me.eccentric_nz.TARDIS.forcefield.TARDISForceFieldPersister;
import me.eccentric_nz.TARDIS.hads.TARDISHadsPersister;
import me.eccentric_nz.TARDIS.move.TARDISPortalPersister;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomPersister;
import me.eccentric_nz.TARDIS.sensor.SensorTracker;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegePersister;
import me.eccentric_nz.TARDIS.skins.SkinPersister;
import me.eccentric_nz.TARDIS.utility.TARDISJunkPlayerPersister;
import me.eccentric_nz.tardisweepingangels.nms.FollowerSaver;

public class TARDISPersister {
    private final TARDIS plugin;

    public TARDISPersister(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void load() {
        new TARDISPortalPersister(this.plugin).load();
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled")) {
            new TARDISArchPersister(this.plugin).checkAll();
        }
        if (this.plugin.getConfig().getBoolean("siege.enabled")) {
            TARDISSiegePersister tsp = new TARDISSiegePersister(this.plugin);
            tsp.loadSiege();
            tsp.loadCubes();
        }
        if (this.plugin.getConfig().getBoolean("allow.hads")) {
            TARDISHadsPersister thp = new TARDISHadsPersister(this.plugin);
            thp.load();
        }
        if (this.plugin.getConfig().getInt("allow.force_field") > 0) {
            new TARDISForceFieldPersister(this.plugin).load();
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews")) {
            new TARDISPreviewPersister(this.plugin).load();
        }
        new TARDISTimeRotorLoader(this.plugin).load();
        new TARDISVortexPersister(this.plugin).load();
        new FlightPersister(this.plugin).load();
        new CameraPersister(this.plugin).load();
        new TARDISJunkPlayerPersister(this.plugin).load();
        new TARDISSeedBlockPersister(this.plugin).load();
        new TARDISRoomPersister(this.plugin).resume();
        new SkinPersister(this.plugin).load();
        SensorTracker.restartCharging(this.plugin);
    }

    public void save() {
        new TARDISRoomPersister(this.plugin).saveProgress();
        new TARDISPortalPersister(this.plugin).save();
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled")) {
            new TARDISArchPersister(this.plugin).saveAll();
        }
        if (this.plugin.getConfig().getBoolean("siege.enabled")) {
            new TARDISSiegePersister(this.plugin).saveCubes();
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews")) {
            new TARDISPreviewPersister(this.plugin).save();
        }
        if (this.plugin.getConfig().getBoolean("allow.hads")) {
            new TARDISHadsPersister(this.plugin).save();
        }
        new TARDISVortexPersister(this.plugin).save();
        new FlightPersister(this.plugin).save();
        new CameraPersister(this.plugin).save();
        if (this.plugin.getConfig().getInt("allow.force_field") > 0) {
            new TARDISForceFieldPersister(this.plugin).save();
        }
        new TARDISSeedBlockPersister(this.plugin).save();
        if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            new FollowerSaver(this.plugin).persist();
        }
        new SkinPersister(this.plugin).save();
    }
}

