/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.rotors.TARDISTimeRotor;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class TARDISDecommissionCommand {
    private final TARDIS plugin;

    TARDISDecommissionCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean withdraw(Player player, String[] args) {
        if (TARDISPermission.hasPermission(player, "tardis.update")) {
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            UUID playerUUID = player.getUniqueId();
            UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return false;
            }
            String tardis_block = TARDISStringUtils.toScoredUppercase(args[1]);
            Block block = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 10);
            String l = block.getLocation().toString();
            try {
                Updateable updateable = Updateable.valueOf(tardis_block);
                if (updateable.equals((Object)Updateable.ROTOR)) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "ROTOR_UNLOCK", "/tardis update rotor unlock", this.plugin);
                    return true;
                }
                if (updateable.equals((Object)Updateable.STORAGE)) {
                    block.setType(Material.NOTE_BLOCK);
                    TARDISDisplayItemUtils.remove(block);
                }
                if (updateable.equals((Object)Updateable.ADVANCED)) {
                    block.setType(Material.JUKEBOX);
                    TARDISDisplayItemUtils.remove(block);
                }
                if (updateable.usesItemFrame()) {
                    ItemFrame itemFrame = null;
                    block7: for (BlockFace face : this.plugin.getGeneralKeeper().getBlockFaces()) {
                        Block b = block.getRelative(face);
                        for (Entity e : b.getWorld().getNearbyEntities(b.getLocation(), 1.0, 1.0, 1.0, d -> d.getType() == EntityType.ITEM_FRAME)) {
                            ItemFrame frame;
                            if (!(e instanceof ItemFrame)) continue;
                            itemFrame = frame = (ItemFrame)e;
                            break block7;
                        }
                    }
                    if (itemFrame != null) {
                        switch (updateable) {
                            case MONITOR: {
                                ItemStack monitor = ItemStack.of((Material)Material.MAP);
                                ItemMeta im = monitor.getItemMeta();
                                im.displayName((Component)Component.text((String)"TARDIS Monitor"));
                                monitor.setItemMeta(im);
                                itemFrame.setItem(monitor);
                                break;
                            }
                            case MONITOR_FRAME: {
                                ItemStack glass = itemFrame.getItem();
                                ItemMeta im = glass.getItemMeta();
                                im.displayName((Component)Component.text((String)"Monitor Frame"));
                                glass.setItemMeta(im);
                                break;
                            }
                            case SONIC_DOCK: {
                                ItemDisplay display = TARDISDisplayItemUtils.getFromBoundingBox(itemFrame.getLocation().getBlock());
                                if (display == null) break;
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DOCK_REMOVE");
                                return true;
                            }
                        }
                        TARDISTimeRotor.unlockItemFrame(itemFrame);
                        this.plugin.getGeneralKeeper().getTimeRotors().remove(itemFrame.getUniqueId());
                        block = itemFrame.getLocation().getBlock();
                        l = itemFrame.getLocation().toString();
                    }
                    this.plugin.getGeneralKeeper().getProtectBlockMap().remove(l);
                    String under = block.getRelative(BlockFace.DOWN).getLocation().toString();
                    this.plugin.getGeneralKeeper().getProtectBlockMap().remove(under);
                    int control = Control.getUPDATE_CONTROLS().get(updateable.getName());
                    this.removeRecord(control, l);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DECOMMISSIONED");
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                return true;
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }

    private void removeRecord(int id, String location) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", id);
        where.put("location", location);
        this.plugin.getQueryFactory().doDelete("controls", where);
    }
}

