/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import com.destroystokyo.paper.MaterialTags;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISBlockScannerData;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class TARDISUpgradeBlockScanner {
    private final TARDIS plugin;
    private final TARDISUpgradeData tud;
    private final UUID uuid;
    private int count = 0;

    public TARDISUpgradeBlockScanner(TARDIS plugin, TARDISUpgradeData tud, UUID uuid) {
        this.plugin = plugin;
        this.tud = tud;
        this.uuid = uuid;
    }

    public TARDISBlockScannerData check() {
        JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", this.tud.getPrevious().getPermission(), this.tud.getPrevious().isCustom());
        if (obj == null) {
            return null;
        }
        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
        int h = dimensions.get("height").getAsInt();
        int w = dimensions.get("width").getAsInt();
        int l = dimensions.get("length").getAsInt();
        float v = h * w * l;
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", this.uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (rs.resultSet()) {
            Material floor_type;
            Material wall_type;
            int startz;
            int startx;
            Tardis tardis = rs.getTardis();
            int slot = tardis.getTIPS();
            if (slot != -1000001) {
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TARDISTIPSData pos = tintpos.getTIPSData(slot);
                startx = pos.getCentreX();
                startz = pos.getCentreZ();
            } else {
                int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                startx = gsl[0];
                startz = gsl[2];
            }
            int starty = this.tud.getPrevious().getStartY();
            World world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
            if (rsp.resultSet()) {
                wall_type = Material.getMaterial((String)rsp.getWall());
                floor_type = Material.getMaterial((String)rsp.getFloor());
            } else {
                wall_type = Material.ORANGE_WOOL;
                floor_type = Material.LIGHT_GRAY_WOOL;
            }
            Object beacon = "";
            JsonArray arr = obj.get("input").getAsJsonArray();
            for (int level = 0; level < h; ++level) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                for (int row = 0; row < w; ++row) {
                    JsonArray r = (JsonArray)floor.get(row);
                    for (int col = 0; col < l; ++col) {
                        Material material;
                        JsonObject c = r.get(col).getAsJsonObject();
                        int x = startx + row;
                        int y = starty + level;
                        int z = startz + col;
                        BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                        Material type = data.getMaterial();
                        Block b = world.getBlockAt(x, y, z);
                        if (type.equals((Object)Material.ORANGE_WOOL)) {
                            type = wall_type;
                        }
                        if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                            type = floor_type;
                        }
                        if (type.equals((Object)Material.SPONGE)) {
                            type = Material.AIR;
                        }
                        if (type.equals((Object)Material.CAKE)) {
                            type = Material.LEVER;
                        }
                        if (type.equals((Object)Material.SPAWNER)) {
                            type = Material.OAK_BUTTON;
                        }
                        if (type.equals((Object)Material.MUSHROOM_STEM)) {
                            type = Material.REPEATER;
                        }
                        if (MaterialTags.INFESTED_BLOCKS.isTagged(type)) {
                            type = Material.AIR;
                        }
                        if (type.equals((Object)Material.BEDROCK)) {
                            type = Material.GLASS;
                            beacon = world.getName() + ":" + x + ":" + y + ":" + z;
                        }
                        if (type.equals((Object)Material.COMMAND_BLOCK)) {
                            type = Material.STONE_BRICKS;
                        }
                        if (type.equals((Object)Material.JUKEBOX) || type.equals((Object)Material.NOTE_BLOCK)) {
                            type = Material.MUSHROOM_STEM;
                        }
                        if (Tag.WOOL.isTagged((Keyed)type)) {
                            UseClay use_clay;
                            try {
                                use_clay = UseClay.valueOf(this.plugin.getConfig().getString("creation.use_clay"));
                            }
                            catch (IllegalArgumentException e) {
                                use_clay = UseClay.WOOL;
                            }
                            switch (type) {
                                case ORANGE_WOOL: {
                                    if (wall_type == Material.LAPIS_BLOCK) {
                                        type = switch (use_clay) {
                                            case UseClay.TERRACOTTA -> Material.ORANGE_TERRACOTTA;
                                            case UseClay.CONCRETE -> Material.ORANGE_CONCRETE;
                                            default -> Material.ORANGE_WOOL;
                                        };
                                        break;
                                    }
                                    type = wall_type;
                                    break;
                                }
                                case LIGHT_GRAY_WOOL: {
                                    if (!this.tud.getSchematic().getPermission().equals("eleventh")) {
                                        if (floor_type == Material.LAPIS_BLOCK) {
                                            type = switch (use_clay) {
                                                case UseClay.TERRACOTTA -> Material.LIGHT_GRAY_TERRACOTTA;
                                                case UseClay.CONCRETE -> Material.LIGHT_GRAY_CONCRETE;
                                                default -> Material.LIGHT_GRAY_WOOL;
                                            };
                                            break;
                                        }
                                        type = floor_type;
                                        break;
                                    }
                                    String[] tsplit = type.toString().split("_");
                                    String m = tsplit.length > 2 ? tsplit[0] + "_" + tsplit[1] + "_" + String.valueOf((Object)use_clay) : tsplit[0] + "_" + String.valueOf((Object)use_clay);
                                    type = Material.getMaterial((String)m);
                                    break;
                                }
                                case BLUE_WOOL: {
                                    type = Material.BARRIER;
                                    break;
                                }
                                default: {
                                    String[] tsplit = type.toString().split("_");
                                    String m = tsplit.length > 2 ? tsplit[0] + "_" + tsplit[1] + "_" + String.valueOf((Object)use_clay) : tsplit[0] + "_" + String.valueOf((Object)use_clay);
                                    type = Material.getMaterial((String)m);
                                }
                            }
                        }
                        if (type.isAir()) {
                            v -= 1.0f;
                        }
                        if ((material = b.getType()).equals((Object)Material.BARRIER) || material.equals((Object)type) || material.isAir() && type.isAir()) continue;
                        ++this.count;
                    }
                }
            }
            TARDISBlockScannerData tbsd = new TARDISBlockScannerData();
            tbsd.setCount(this.count);
            tbsd.setVolume(v);
            int changed = (int)((float)this.count / v * 100.0f);
            tbsd.setChanged(changed);
            tbsd.setAllow(changed < this.plugin.getConfig().getInt("desktop.block_change_percent"));
            tbsd.setBeacon((String)beacon);
            return tbsd;
        }
        return null;
    }
}

