/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDISSeedRecipe {
    private final TARDIS plugin;
    private final HashMap<Schematic, ShapedRecipe> seedRecipes;

    public TARDISSeedRecipe(TARDIS plugin) {
        this.plugin = plugin;
        this.seedRecipes = new HashMap();
    }

    public void addSeedRecipes() {
        for (Schematic schematic : Consoles.getBY_MATERIALS().values()) {
            ShapedRecipe recipe = this.makeSeedRecipe(schematic);
            this.plugin.getServer().addRecipe((Recipe)recipe);
            this.plugin.getFigura().getShapedRecipes().put(TARDISStringUtils.capitalise(schematic.getPermission()), recipe);
        }
    }

    private ShapedRecipe makeSeedRecipe(Schematic s) {
        ItemStack is;
        NamespacedKey model = TARDISDisplayItem.CUSTOM.getCustomModel();
        if (s.isCustom()) {
            is = ItemStack.of((Material)s.getSeedMaterial(), (int)1);
        } else {
            try {
                TARDISDisplayItem tdi = TARDISDisplayItem.valueOf(s.getPermission().toUpperCase(Locale.ROOT));
                model = tdi.getCustomModel();
                is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Could not get display item for console! " + e.getMessage());
                is = ItemStack.of((Material)TARDISDisplayItem.CUSTOM.getMaterial(), (int)1);
            }
        }
        ItemMeta im = is.getItemMeta();
        im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)model.getKey());
        im.displayName((Component)ComponentUtils.toGold("TARDIS Seed Block"));
        im.lore(List.of(Component.text((String)s.getPermission().toUpperCase(Locale.ROOT))));
        is.setItemMeta(im);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, s.getPermission() + "_seed");
        ShapedRecipe r = new ShapedRecipe(key, is);
        r.shape(new String[]{"T  ", "L W", "S F"});
        Material torch = Material.REDSTONE_TORCH;
        if (!this.plugin.getConfig().getBoolean("creation.seed_block.legacy")) {
            World world = (World)this.plugin.getServer().getWorlds().getFirst();
            String difficulty = switch (world.getDifficulty()) {
                case Difficulty.HARD -> "hard";
                case Difficulty.NORMAL -> "normal";
                default -> "easy";
            };
            try {
                torch = Material.valueOf((String)this.plugin.getConfig().getString("creation.seed_block." + difficulty));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        r.setIngredient('T', torch);
        r.setIngredient('L', Material.LAPIS_BLOCK);
        r.setIngredient('W', (RecipeChoice)TARDISWalls.CHOICES);
        r.setIngredient('S', s.getSeedMaterial());
        r.setIngredient('F', (RecipeChoice)TARDISWalls.CHOICES);
        this.seedRecipes.put(s, r);
        return r;
    }

    public HashMap<Schematic, ShapedRecipe> getSeedRecipes() {
        return this.seedRecipes;
    }
}

