/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.DyeColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TabComplete
extends TARDISCompleter
implements TabCompleter {
    final ImmutableList<String> CMD_SUBS = ImmutableList.of((Object)"spawn", (Object)"equip", (Object)"disguise", (Object)"kill", (Object)"count", (Object)"follow", (Object)"stay", (Object)"remove", (Object)"set", (Object)"give", (Object)"teleport");
    private final ImmutableList<String> ONOFF_SUBS = ImmutableList.of((Object)"on", (Object)"off");
    private final ImmutableList<String> TP_SUBS = ImmutableList.of((Object)"replace", (Object)"true", (Object)"false");
    private final ImmutableList<String> WORLD_SUBS;
    private final ImmutableList<String> MONSTER_SUBS;
    private final List<String> COLOUR_SUBS = new ArrayList<String>();

    public TabComplete(TARDIS plugin) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Monster m : Monster.values()) {
            tmp.add(m.toString());
        }
        this.MONSTER_SUBS = ImmutableList.copyOf(tmp);
        ArrayList worlds = new ArrayList();
        plugin.getServer().getWorlds().forEach(w -> worlds.add(w.getName()));
        this.WORLD_SUBS = ImmutableList.copyOf(worlds);
        for (DyeColor dye : DyeColor.values()) {
            this.COLOUR_SUBS.add(dye.toString());
        }
        this.COLOUR_SUBS.add("flying");
        this.COLOUR_SUBS.add("flaming");
        this.COLOUR_SUBS.add("CYBERMAN_RISE");
        this.COLOUR_SUBS.add("CYBER_LORD");
        this.COLOUR_SUBS.add("BLACK_CYBERMAN");
        this.COLOUR_SUBS.add("CYBERMAN_EARTHSHOCK");
        this.COLOUR_SUBS.add("CYBERMAN_INVASION");
        this.COLOUR_SUBS.add("CYBERMAN_MOONBASE");
        this.COLOUR_SUBS.add("CYBERMAN_TENTH_PLANET");
        this.COLOUR_SUBS.add("WOOD_CYBERMAN");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                return this.partial(args[0], (Collection<String>)this.CMD_SUBS);
            }
            case 2: {
                if (args[0].equals("give")) {
                    return null;
                }
                if (args[0].equals("teleport")) {
                    return this.partial(args[1], (Collection<String>)this.TP_SUBS);
                }
                return this.partial(args[1], (Collection<String>)this.MONSTER_SUBS);
            }
            case 3: {
                return switch (args[0]) {
                    case "disguise" -> this.partial(args[2], (Collection<String>)this.ONOFF_SUBS);
                    case "give" -> this.partial(args[2], (Collection<String>)this.MONSTER_SUBS);
                    case "follow" -> List.of("15");
                    case "spawn", "equip" -> this.partial(args[2], this.COLOUR_SUBS);
                    default -> this.partial(args[2], (Collection<String>)this.WORLD_SUBS);
                };
            }
        }
        return ImmutableList.of();
    }
}

