/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.spawner;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SpawnerListener
implements Listener {
    private final TARDIS plugin;

    public SpawnerListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSpawn(SpawnerSpawnEvent event) {
        CreatureSpawner spawner = event.getSpawner();
        if (spawner.getPersistentDataContainer().has(TARDISWeepingAngels.MONSTER_HEAD, PersistentDataType.STRING)) {
            String m = (String)spawner.getPersistentDataContainer().get(TARDISWeepingAngels.MONSTER_HEAD, PersistentDataType.STRING);
            Monster monster = Monster.valueOf(m);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(monster, (LivingEntity)event.getEntity(), false).setHelmetAndInvisibility();
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent(event.getEntity(), EntityType.SKELETON, Monster.SILURIAN, spawner.getLocation()));
            }, 5L);
        }
    }

    @EventHandler
    public void onSpawnerClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.SPAWNER) {
            return;
        }
        ItemStack is = event.getItem();
        if (is == null || !is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (im == null || !im.getPersistentDataContainer().has(TARDISWeepingAngels.MONSTER_HEAD, PersistentDataType.INTEGER)) {
            return;
        }
        if (!event.getPlayer().isOp()) {
            this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.MONSTERS, "NO_PERMS");
            return;
        }
        NamespacedKey key = im.getItemModel();
        if (key == null) {
            return;
        }
        for (Monster monster : Monster.values()) {
            if (!key.equals((Object)monster.getHeadModel())) continue;
            this.setCustomSpawner(block, monster);
            break;
        }
    }

    private void setCustomSpawner(Block block, Monster monster) {
        BlockState state = block.getState();
        if (state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)state;
            spawner.getPersistentDataContainer().set(TARDISWeepingAngels.MONSTER_HEAD, PersistentDataType.STRING, (Object)monster.name());
            spawner.setSpawnedType(monster.getEntityType());
            spawner.update();
        }
    }
}

