/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.utils.TARDISWeather;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Weather;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISWeatherCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"clear", (Object)"c", (Object)"rain", (Object)"r", (Object)"thunder", (Object)"t", (Object)"sun", (Object)"s");

    public TARDISWeatherCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisweather")) {
            if (args.length < 1) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return true;
            }
            if (sender instanceof Player) {
                Weather weather;
                String perm;
                Player player = (Player)sender;
                if (!this.plugin.getConfig().getBoolean("allow.weather_set")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_DISABLED");
                    return true;
                }
                Location location = player.getLocation();
                World world = location.getWorld();
                if (this.plugin.getUtils().inTARDISWorld(player)) {
                    int id = this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(player);
                    ResultSetCurrentFromId rs = new ResultSetCurrentFromId(this.plugin, id);
                    if (rs.resultSet()) {
                        world = rs.getCurrent().location().getWorld();
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_TARDIS");
                        return true;
                    }
                }
                if (!TARDISPermission.hasPermission(player, "tardis.weather." + (perm = (weather = Weather.fromString(args[0])).toString().toLowerCase(Locale.ROOT)))) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                    return true;
                }
                TARDISWeather.setWeather(world, weather);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_SET", perm);
                return true;
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        return ImmutableList.of();
    }
}

