/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUISonicGenerator;
import me.eccentric_nz.TARDIS.database.data.Sonic;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

class TARDISSonicGeneratorInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Sonic data;
    private final Inventory inventory;

    public TARDISSonicGeneratorInventory(TARDIS plugin, Sonic data) {
        this.plugin = plugin;
        this.data = data;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Sonic Generator", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        for (GUISonicGenerator sonic : GUISonicGenerator.values()) {
            ItemMeta im;
            ItemStack is;
            if (sonic.getMaterial() == Material.BLAZE_ROD) {
                is = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
                im = is.getItemMeta();
                im.displayName((Component)ComponentUtils.toWhite("Sonic Screwdriver"));
                im.lore(List.of(Component.text((String)sonic.getName())));
                CustomModelDataComponent component = im.getCustomModelDataComponent();
                component.setFloats(sonic.getFloats());
                im.setCustomModelDataComponent(component);
                is.setItemMeta(im);
                stack[sonic.getSlot()] = is;
            }
            if (sonic.getMaterial() != Material.BOWL || sonic.getSlot() == 45) continue;
            is = ItemStack.of((Material)Material.BOWL, (int)1);
            im = is.getItemMeta();
            im.displayName((Component)Component.text((String)sonic.getName()));
            if (!sonic.getLore().isEmpty()) {
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                for (String s : sonic.getLore().split("~")) {
                    lore.add(Component.text((String)s));
                }
                im.lore(lore);
            }
            is.setItemMeta(im);
            stack[sonic.getSlot()] = is;
        }
        ItemStack info = ItemStack.of((Material)Material.BOOK, (int)1);
        ItemMeta info_im = info.getItemMeta();
        info_im.displayName((Component)Component.text((String)"Instructions (1/3)"));
        info_im.lore(List.of(Component.text((String)"Select your Sonic Screwdriver"), Component.text((String)"type from the top two rows."), Component.text((String)"Click on the upgrades you"), Component.text((String)"want to add to the sonic.")));
        info.setItemMeta(info_im);
        stack[38] = info;
        ItemStack info1 = ItemStack.of((Material)Material.BOOK, (int)1);
        ItemMeta info1_im = info.getItemMeta();
        info1_im.displayName((Component)Component.text((String)"Instructions (2/3)"));
        info1_im.lore(List.of(Component.text((String)"You can reset the upgrades"), Component.text((String)"by clicking the 'Standard' button."), Component.text((String)"The Artron cost for the"), Component.text((String)"sonic is shown bottom left.")));
        info1.setItemMeta(info1_im);
        stack[39] = info1;
        ItemStack info2 = ItemStack.of((Material)Material.BOOK, (int)1);
        ItemMeta info2_im = info.getItemMeta();
        info2_im.displayName((Component)Component.text((String)"Instructions (3/3)"));
        info2_im.lore(List.of(Component.text((String)"The final sonic result"), Component.text((String)"is shown in the middle"), Component.text((String)"of the bottom row.")));
        info2.setItemMeta(info2_im);
        stack[40] = info2;
        ItemStack sonic = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
        ItemMeta screw = sonic.getItemMeta();
        screw.displayName((Component)Component.text((String)"Sonic Screwdriver"));
        CustomModelDataComponent scomponent = screw.getCustomModelDataComponent();
        scomponent.setFloats(this.data.getModel());
        screw.setCustomModelDataComponent(scomponent);
        ArrayList<TextComponent> upgrades = new ArrayList<TextComponent>();
        double full = this.plugin.getArtronConfig().getDouble("full_charge") / 100.0;
        int artron = (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.standard") * full);
        if (this.data.hasBio()) {
            upgrades.add(Component.text((String)"Bio-scanner Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full);
        }
        if (this.data.hasDiamond()) {
            upgrades.add(Component.text((String)"Diamond Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.diamond") * full);
        }
        if (this.data.hasEmerald()) {
            upgrades.add(Component.text((String)"Emerald Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.emerald") * full);
        }
        if (this.data.hasRedstone()) {
            upgrades.add(Component.text((String)"Redstone Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.redstone") * full);
        }
        if (this.data.hasPainter()) {
            upgrades.add(Component.text((String)"Painter Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.painter") * full);
        }
        if (this.data.hasIgnite()) {
            upgrades.add(Component.text((String)"Ignite Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.ignite") * full);
        }
        if (this.data.hasArrow()) {
            upgrades.add(Component.text((String)"Pickup Arrows Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.arrow") * full);
        }
        if (this.data.hasKnockback()) {
            upgrades.add(Component.text((String)"Knockback Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.knockback") * full);
        }
        if (this.data.hasBrush()) {
            upgrades.add(Component.text((String)"Brush Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.brush") * full);
        }
        if (this.data.hasConversion()) {
            upgrades.add(Component.text((String)"Conversion Upgrade"));
            artron += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.conversion") * full);
        }
        ItemStack cost = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta cost_im = cost.getItemMeta();
        cost_im.displayName((Component)Component.text((String)"Artron cost"));
        cost_im.lore(List.of(Component.text((int)artron)));
        cost.setItemMeta(cost_im);
        stack[45] = cost;
        if (!upgrades.isEmpty()) {
            ArrayList<TextComponent> finalUps = new ArrayList<TextComponent>();
            finalUps.add(Component.text((String)"Upgrades:"));
            finalUps.addAll(upgrades);
            screw.lore(finalUps);
        }
        sonic.setItemMeta(screw);
        stack[49] = sonic;
        return stack;
    }
}

