/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.formula.FormulaViewer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FormulaViewerListener
extends TARDISMenuListener {
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final TARDIS plugin;

    public FormulaViewerListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onFormulaViewerOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder() instanceof FormulaViewer) {
            Player player = (Player)event.getPlayer();
            UUID uuid = player.getUniqueId();
            this.viewers.add(uuid);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFormulaViewerClick(InventoryClickEvent event) {
        Player player;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.CHEST && this.viewers.contains((player = (Player)event.getWhoClicked()).getUniqueId())) {
            ItemStack is;
            event.setCancelled(true);
            if (event.getRawSlot() == 26) {
                this.close(player);
            } else if (event.getRawSlot() != 0 && (is = event.getCurrentItem()) != null && is.hasItemMeta() && Objects.requireNonNull(is.getItemMeta()).hasDisplayName()) {
                try {
                    Compound compound = Compound.valueOf(ComponentUtils.stripColour(is.getItemMeta().displayName()).replace(" ", "_"));
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new FormulaViewer(this.plugin, player).getCompoundFormula(compound), 2L);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFormulaViewerClose(InventoryCloseEvent event) {
        Player p;
        UUID uuid;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.CHEST && this.viewers.contains(uuid = (p = (Player)event.getPlayer()).getUniqueId())) {
            this.viewers.remove(uuid);
            event.getView().getTopInventory().clear();
            p.updateInventory();
        }
    }
}

