/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.vashta_nerada;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class VashtaNeradaListener
implements Listener {
    private final TARDIS plugin;

    public VashtaNeradaListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBookshelfBreak(BlockBreakEvent event) {
        Block b = event.getBlock();
        if (b.getType().equals((Object)Material.BOOKSHELF)) {
            Location l;
            String name = WorldProcessor.sanitiseName(b.getWorld().getName());
            if (this.plugin.getMonstersConfig().getInt("vashta_nerada.worlds." + name) > 0 && TARDISConstants.RANDOM.nextInt(100) < this.plugin.getMonstersConfig().getInt("vashta_nerada.worlds." + name) && (l = this.getClearLocation(event.getPlayer())) != null) {
                this.spawnVashtaNerada(l);
            }
        }
    }

    private Location getClearLocation(Player p) {
        Location ret = null;
        Block l = p.getLocation().getBlock();
        World w = l.getWorld();
        for (BlockFace f : this.plugin.getGeneralKeeper().getShuffledFaces()) {
            Block b = l.getRelative(f, 3);
            if (!b.getType().equals((Object)Material.AIR) || !b.getRelative(BlockFace.UP).getType().equals((Object)Material.AIR)) continue;
            ret = new Location(w, (double)b.getX() + 0.5, (double)b.getY(), (double)b.getZ() + 0.5);
            break;
        }
        return ret;
    }

    private void spawnVashtaNerada(Location l) {
        LivingEntity vashta = new MonsterSpawner().create(l, Monster.VASHTA_NERADA);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            new Equipper(Monster.VASHTA_NERADA, vashta, false).setHelmetAndInvisibility();
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)vashta, EntityType.ZOMBIE, Monster.VASHTA_NERADA, l));
        }, 5L);
    }
}

