/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.api;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.WorldAndRange;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;

class TARDISRandomLocation {
    private final TARDIS plugin;

    TARDISRandomLocation(TARDIS plugin) {
        this.plugin = plugin;
    }

    final List<World> getWorlds(List<String> list) {
        ArrayList<World> worlds = new ArrayList<World>();
        list.forEach(s -> {
            World o = TARDISAliasResolver.getWorldFromAlias(s);
            if (o != null) {
                worlds.add(o);
            }
        });
        return worlds;
    }

    WorldAndRange getWorldandRange(List<World> worlds) {
        int listlen = worlds.size();
        World w = worlds.get(TARDISConstants.RANDOM.nextInt(listlen));
        World.Environment env = w.getEnvironment();
        int cx = this.plugin.getConfig().getInt("travel.random_circuit.x");
        int cz = this.plugin.getConfig().getInt("travel.random_circuit.z");
        int minX = -cx;
        int maxX = cx;
        int minZ = -cz;
        int maxZ = cz;
        WorldBorder wb = w.getWorldBorder();
        int size = (int)wb.getSize() / 2;
        Location centre = wb.getCenter();
        if (size < 30000000) {
            minX = centre.getBlockX() - size;
            minZ = centre.getBlockZ() - size;
            maxX = centre.getBlockX() + size;
            maxZ = centre.getBlockZ() + size;
        }
        if (env.equals((Object)World.Environment.NETHER)) {
            minX /= 8;
            maxX /= 8;
            minZ /= 8;
            maxZ /= 8;
        }
        if (env.equals((Object)World.Environment.THE_END)) {
            minX = -120;
            maxX = 120;
            minZ = -120;
            maxZ = 120;
        }
        int rangeX = Math.abs(minX) + maxX;
        int rangeZ = Math.abs(minZ) + maxZ;
        return new WorldAndRange(w, minX, minZ, rangeX, rangeZ);
    }
}

