/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.World;

public class ResultSetBackLocation {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String prefix;
    private int back_id;
    private int tardis_id;
    private World world;
    private int x;
    private int y;
    private int z;
    private COMPASS direction;
    private boolean submarine;

    public ResultSetBackLocation(TARDIS plugin, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block22: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "back" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        this.back_id = rs.getInt("back_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.world = TARDISAliasResolver.getWorldFromAlias(rs.getString("world"));
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                        this.direction = COMPASS.valueOf(rs.getString("direction"));
                        this.submarine = rs.getBoolean("submarine");
                    }
                    break block22;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for destinations table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing destinations table! " + e.getMessage());
                }
            }
        }
        return this.world != null;
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public COMPASS getDirection() {
        return this.direction;
    }

    public boolean isSubmarine() {
        return this.submarine;
    }
}

