/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.api.event.TARDISMalfunctionEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISMaterialisationEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteractionCheck;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.TARDISManualFlightStarter;
import me.eccentric_nz.TARDIS.flight.TARDISRegulatorStarter;
import me.eccentric_nz.TARDIS.flight.TARDISTravelBar;
import me.eccentric_nz.TARDIS.hads.TARDISCloisterBell;
import me.eccentric_nz.TARDIS.travel.TARDISMalfunction;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;

public class TARDISMaterialseFromVortex
implements Runnable {
    private final TARDIS plugin;
    private final int id;
    private final Player player;
    private final Location handbrake;
    private final Throticle throticle;

    public TARDISMaterialseFromVortex(TARDIS plugin, int id, Player player, Location handbrake, Throticle throticle) {
        this.plugin = plugin;
        this.id = id;
        this.player = player;
        this.handbrake = handbrake;
        this.throticle = throticle;
    }

    @Override
    public void run() {
        UUID uuid = this.player.getUniqueId();
        ResultSetNextLocation rsn = new ResultSetNextLocation(this.plugin, this.id);
        if (!rsn.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NO_LOAD");
            return;
        }
        Location exit = new Location(rsn.getWorld(), (double)rsn.getX(), (double)rsn.getY(), (double)rsn.getZ());
        boolean is_next_sub = rsn.isSubmarine();
        boolean malfunction = this.plugin.getTrackerKeeper().getMalfunction().containsKey(this.id) && this.plugin.getTrackerKeeper().getMalfunction().get(this.id) != false;
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
            if (rsc.resultSet()) {
                Current current = rsc.getCurrent();
                BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
                if (malfunction) {
                    TARDISMalfunction m = new TARDISMalfunction(this.plugin);
                    exit = m.getMalfunction(this.id, this.player, current.direction(), this.handbrake, tardis.getEps(), tardis.getCreeper());
                    if (exit != null) {
                        this.plugin.getTrackerKeeper().getRescue().remove(this.id);
                        HashMap<String, Object> wheress = new HashMap<String, Object>();
                        wheress.put("tardis_id", this.id);
                        HashMap<String, Object> setsave = new HashMap<String, Object>();
                        setsave.put("world", exit.getWorld().getName());
                        setsave.put("x", exit.getBlockX());
                        setsave.put("y", exit.getBlockY());
                        setsave.put("z", exit.getBlockZ());
                        setsave.put("submarine", 0);
                        this.plugin.getQueryFactory().doSyncUpdate("next", setsave, wheress);
                        if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(this.id)) {
                            int amount = Math.round((float)this.plugin.getTrackerKeeper().getHasDestination().get(this.id).cost() * this.throticle.throttle().getArtronMultiplier());
                            HashMap<String, Object> wheret = new HashMap<String, Object>();
                            wheret.put("tardis_id", this.id);
                            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, wheret, this.player);
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "Q_FLY");
                            this.plugin.getTrackerKeeper().getHasDestination().remove(this.id);
                        }
                        this.plugin.getPM().callEvent((Event)new TARDISMalfunctionEvent(this.player, tardis, exit));
                        if (!tardis.getBeacon().isEmpty()) {
                            this.setBeaconUpBlock(tardis.getBeacon(), this.id);
                        }
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                            TARDISSounds.playTARDISSound(this.handbrake, "tardis_malfunction");
                        }
                        this.player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 150, 5));
                        long cloister_delay = this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id) ? 262L : 360L;
                        Location location = exit;
                        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            TARDISCloisterBell bell = new TARDISCloisterBell(this.plugin, 6, this.id, location, this.plugin.getServer().getPlayer(uuid), true, "a flight malfunction", false);
                            int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
                            bell.setTask(taskID);
                            this.plugin.getTrackerKeeper().getCloisterBells().put(this.id, taskID);
                        }, cloister_delay);
                    } else {
                        malfunction = false;
                    }
                }
                if (exit != null) {
                    if (!exit.getWorld().isChunkLoaded(exit.getChunk())) {
                        exit.getWorld().loadChunk(exit.getChunk());
                    }
                    ChameleonPreset preset = tardis.getPreset();
                    COMPASS sd = rsn.getDirection();
                    ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                    boolean minecart = false;
                    boolean bar = false;
                    int flight_mode = 1;
                    SpaceTimeThrottle spaceTimeThrottle = SpaceTimeThrottle.NORMAL;
                    if (rsp.resultSet()) {
                        minecart = rsp.isMinecartOn();
                        bar = rsp.isTravelbarOn();
                        flight_mode = rsp.getFlightMode();
                        if (flight_mode == 1 && !malfunction) {
                            spaceTimeThrottle = SpaceTimeThrottle.getByDelay().get(rsp.getThrottle());
                        }
                    }
                    BuildData bd = new BuildData(uuid.toString());
                    bd.setDirection(sd);
                    bd.setLocation(exit);
                    bd.setMalfunction(false);
                    bd.setOutside(false);
                    bd.setPlayer((OfflinePlayer)this.player);
                    bd.setRebuild(false);
                    bd.setSubmarine(is_next_sub);
                    bd.setTardisID(this.id);
                    bd.setThrottle(spaceTimeThrottle);
                    bd.setParticles(this.throticle.particles());
                    String landSFX = spaceTimeThrottle != SpaceTimeThrottle.NORMAL ? "tardis_land_" + spaceTimeThrottle.toString().toLowerCase(Locale.ROOT) : "tardis_land";
                    long travel_time = malfunction ? 400L : (long)((double)spaceTimeThrottle.getFlightTime() * 0.75) + 4L;
                    long flight_mode_delay = this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id) ? 0L : spaceTimeThrottle.getFlightTime();
                    this.plugin.getTrackerKeeper().getFlightData().put(uuid, bd);
                    long materialisation_delay = flight_mode_delay;
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id) && malfunction) {
                        materialisation_delay += 262L;
                        travel_time += 262L;
                    }
                    if (flight_mode == 2 || flight_mode == 3) {
                        Runnable runner;
                        materialisation_delay += 650L;
                        travel_time += 650L;
                        if (flight_mode == 2) {
                            runner = new TARDISRegulatorStarter(this.plugin, this.player, this.id);
                        } else {
                            ResultSetInteractionCheck rsic = new ResultSetInteractionCheck(this.plugin);
                            runner = new TARDISManualFlightStarter(this.plugin, this.player, this.id, rsic.resultSetFromId(this.id));
                        }
                        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, runner, flight_mode_delay);
                    }
                    if (bar) {
                        long tt = travel_time;
                        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISTravelBar(this.plugin, this.id).showTravelRemaining(this.player, tt, false), flight_mode_delay);
                    }
                    scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.id)) {
                            scheduler.cancelTask(this.plugin.getTrackerKeeper().getDestinationVortex().get(this.id).intValue());
                        }
                    }, materialisation_delay - 140L);
                    boolean mine_sound = minecart;
                    Location sound_loc = preset.equals((Object)ChameleonPreset.JUNK_MODE) ? exit : this.handbrake;
                    Location external_sound_loc = exit;
                    boolean malchk = malfunction;
                    scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        int distance;
                        Location final_location = bd.getLocation();
                        this.plugin.getPM().callEvent((Event)new TARDISMaterialisationEvent(this.player, tardis, final_location));
                        this.plugin.getPresetBuilder().buildPreset(bd);
                        if (!mine_sound) {
                            if (!preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                                if (!malchk) {
                                    TARDISSounds.playTARDISSound(sound_loc, landSFX);
                                    TARDISSounds.playTARDISSound(external_sound_loc, landSFX);
                                } else {
                                    TARDISSounds.playTARDISSound(sound_loc, "tardis_emergency_land");
                                    TARDISSounds.playTARDISSound(external_sound_loc, "tardis_emergency_land");
                                }
                            } else {
                                TARDISSounds.playTARDISSound(sound_loc, "junk_land");
                            }
                        } else {
                            this.handbrake.getWorld().playSound(this.handbrake, Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                        }
                        HashMap<String, Object> setcurrent = new HashMap<String, Object>();
                        HashMap<String, Object> wherecurrent = new HashMap<String, Object>();
                        HashMap<String, Object> setback = new HashMap<String, Object>();
                        HashMap<String, Object> whereback = new HashMap<String, Object>();
                        HashMap<String, Object> setdoor = new HashMap<String, Object>();
                        HashMap<String, Object> wheredoor = new HashMap<String, Object>();
                        setcurrent.put("world", final_location.getWorld().getName());
                        setcurrent.put("x", final_location.getBlockX());
                        setcurrent.put("y", final_location.getBlockY());
                        setcurrent.put("z", final_location.getBlockZ());
                        String direction = preset.usesArmourStand() ? bd.getDirection().toString() : bd.getDirection().forPreset().toString();
                        setcurrent.put("direction", direction);
                        setcurrent.put("submarine", bd.isSubmarine() ? 1 : 0);
                        wherecurrent.put("tardis_id", this.id);
                        setback.put("world", current.location().getWorld().getName());
                        setback.put("x", current.location().getBlockX());
                        setback.put("y", current.location().getBlockY());
                        setback.put("z", current.location().getBlockZ());
                        setback.put("direction", current.direction().toString());
                        setback.put("submarine", current.submarine() ? 1 : 0);
                        whereback.put("tardis_id", this.id);
                        setdoor.put("door_direction", bd.getDirection().forPreset().toString());
                        wheredoor.put("tardis_id", this.id);
                        wheredoor.put("door_type", 0);
                        if (!setcurrent.isEmpty()) {
                            this.plugin.getQueryFactory().doUpdate("current", setcurrent, wherecurrent);
                            this.plugin.getQueryFactory().doUpdate("back", setback, whereback);
                            this.plugin.getQueryFactory().doUpdate("doors", setdoor, wheredoor);
                        }
                        if (this.plugin.getAchievementConfig().getBoolean("travel.enabled") && !this.plugin.getTrackerKeeper().getResetWorlds().contains(current.location().getWorld().getName()) && current.location().getWorld().equals((Object)final_location.getWorld()) && (distance = (int)current.location().distance(final_location)) > 0 && this.plugin.getAchievementConfig().getBoolean("travel.enabled")) {
                            TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, this.player, Advancement.TRAVEL, 1);
                            taf.doAchievement(distance);
                        }
                        if (!malchk) {
                            this.plugin.getTrackerKeeper().getFlightData().remove(uuid);
                        }
                    }, materialisation_delay);
                    this.plugin.getTrackerKeeper().getHadsDamage().remove(this.id);
                    long now = TARDISPermission.hasPermission(this.player, "tardis.prune.bypass") ? Long.MAX_VALUE : System.currentTimeMillis();
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("lastuse", now);
                    HashMap<String, Object> whereh = new HashMap<String, Object>();
                    whereh.put("tardis_id", this.id);
                    this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
                }
            }
        }
    }

    private void setBeaconUpBlock(String str, int id) {
        Location bl = TARDISStaticLocationGetters.getLocationFromDB(str);
        Block b = bl.getBlock();
        while (!b.getType().equals((Object)Material.BEACON) && b.getLocation().getBlockY() > 0) {
            b = b.getRelative(BlockFace.DOWN);
        }
        TARDISBlockSetters.setBlockAndRemember(b.getRelative(BlockFace.UP), Material.RED_STAINED_GLASS, id, 2);
    }
}

