/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import com.destroystokyo.paper.MaterialTags;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.junk.TARDISJunkItsDangerousRunnable;
import me.eccentric_nz.TARDIS.junk.TARDISJunkReturnPersiter;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISJunkBuilder
implements Runnable {
    private final TARDIS plugin;
    private final BuildData bd;
    private final int sx;
    private final int sy;
    private final int sz;
    private final Location loc;
    private final Location effectsLoc;
    private final World world;
    private int task;
    private int fryTask;
    private int i = 0;

    public TARDISJunkBuilder(TARDIS plugin, BuildData bd) {
        plugin.debug("TARDISJunkBuilder");
        this.plugin = plugin;
        this.bd = bd;
        this.loc = this.bd.getLocation();
        this.effectsLoc = this.loc.clone().add(0.5, 0.0, 0.5);
        this.sx = this.loc.getBlockX() - 3;
        this.sy = this.loc.getBlockY();
        this.sz = this.loc.getBlockZ() - 2;
        this.world = this.loc.getWorld();
    }

    @Override
    public void run() {
        if (!this.plugin.getTrackerKeeper().getDematerialising().contains(this.bd.getTardisID())) {
            if (this.i < 24) {
                ++this.i;
                if (this.i == 2) {
                    this.plugin.getUtils().getJunkTravellers(this.loc).forEach(e -> {
                        if (e instanceof Player) {
                            Player p = (Player)e;
                            TARDISSounds.playTARDISSound(p, "junk_land", 5L);
                        }
                    });
                    this.fryTask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TARDISJunkItsDangerousRunnable(this.plugin, this.loc), 0L, 1L);
                }
                if (this.i == 1) {
                    Material wall_type;
                    Material floor_type;
                    ResultSetPlayerPrefs rsp;
                    if (this.plugin.getConfig().getInt("junk.return") > 0) {
                        this.loc.getChunk().addPluginChunkTicket((Plugin)this.plugin);
                    }
                    if ((rsp = new ResultSetPlayerPrefs(this.plugin, "00000000-aaaa-bbbb-cccc-000000000000")).resultSet()) {
                        floor_type = Material.valueOf((String)rsp.getFloor());
                        wall_type = Material.valueOf((String)rsp.getWall());
                    } else {
                        floor_type = Material.LIGHT_GRAY_WOOL;
                        wall_type = Material.ORANGE_WOOL;
                    }
                    Block postTerminalBlock = null;
                    JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", "junk", false);
                    if (obj != null) {
                        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                        int h = dimensions.get("height").getAsInt();
                        int w = dimensions.get("width").getAsInt();
                        int l = dimensions.get("length").getAsInt();
                        JsonArray arr = obj.get("input").getAsJsonArray();
                        for (int level = 0; level < h; ++level) {
                            JsonArray floor = arr.get(level).getAsJsonArray();
                            for (int row = 0; row < w; ++row) {
                                JsonArray r = (JsonArray)floor.get(row);
                                block8: for (int col = 0; col < l; ++col) {
                                    JsonObject c = r.get(col).getAsJsonObject();
                                    int x = this.sx + row;
                                    int y = this.sy + level;
                                    int z = this.sz + col;
                                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                                    Material type = data.getMaterial();
                                    if (type.equals((Object)Material.CAKE)) {
                                        String handbrakeloc = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 0, handbrakeloc, 0);
                                    }
                                    if (type.equals((Object)Material.STONE_BUTTON)) {
                                        String stone_button = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 1, stone_button, 0);
                                    }
                                    if (type.equals((Object)Material.OAK_BUTTON)) {
                                        String wood_button = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 6, wood_button, 0);
                                    }
                                    if (type.equals((Object)Material.CRIMSON_BUTTON)) {
                                        String crimson_button = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 52, crimson_button, 0);
                                    }
                                    if (type.equals((Object)Material.REPEATER)) {
                                        String repeater = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 2, repeater, 0);
                                    }
                                    if (type.equals((Object)Material.COMPARATOR)) {
                                        String comparator = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 3, comparator, 0);
                                    }
                                    if (MaterialTags.INFESTED_BLOCKS.isTagged(type)) {
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 9, new Location(this.world, (double)x, (double)y, (double)z).toString(), 0);
                                        postTerminalBlock = this.world.getBlockAt(x, y, z);
                                    }
                                    if (type.equals((Object)Material.TRIPWIRE_HOOK)) {
                                        String trip = TARDISStaticLocationGetters.makeLocationStr(this.world, x, y, z);
                                        this.plugin.getQueryFactory().insertSyncControl(this.bd.getTardisID(), 4, trip, 0);
                                    }
                                    switch (type) {
                                        case SPONGE: 
                                        case AIR: {
                                            TARDISBlockSetters.setBlock(this.world, x, y, z, Material.AIR);
                                            continue block8;
                                        }
                                        case CAKE: {
                                            BlockData handbrake = Material.LEVER.createBlockData();
                                            Switch lever = (Switch)handbrake;
                                            lever.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                                            lever.setFacing(BlockFace.SOUTH);
                                            TARDISBlockSetters.setBlockAndRemember(this.world, x, y, z, (BlockData)lever, this.bd.getTardisID());
                                            continue block8;
                                        }
                                        case ORANGE_WOOL: {
                                            BlockData wall;
                                            if (wall_type.equals((Object)Material.ORANGE_WOOL)) {
                                                wall = TARDISConstants.BARRIER;
                                                TARDISDisplayItemUtils.set(TARDISDisplayItem.HEXAGON, this.world, x, y, z);
                                            } else {
                                                wall = wall_type.createBlockData();
                                            }
                                            TARDISBlockSetters.setBlockAndRemember(this.world, x, y, z, wall, this.bd.getTardisID());
                                            continue block8;
                                        }
                                        case LIGHT_GRAY_WOOL: {
                                            TARDISBlockSetters.setBlockAndRemember(this.world, x, y, z, floor_type, this.bd.getTardisID());
                                            continue block8;
                                        }
                                        default: {
                                            TARDISBlockSetters.setBlockAndRemember(this.world, x, y, z, data, this.bd.getTardisID());
                                        }
                                    }
                                }
                            }
                        }
                        if (postTerminalBlock != null) {
                            Directional sign = (Directional)Material.OAK_WALL_SIGN.createBlockData();
                            sign.setFacing(BlockFace.EAST);
                            postTerminalBlock.setBlockData((BlockData)sign);
                            if (Tag.WALL_SIGNS.isTagged((Keyed)postTerminalBlock.getType())) {
                                Sign ts = (Sign)postTerminalBlock.getState();
                                ts.getSide(Side.FRONT).line(0, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("junk").getFirst())));
                                ts.update();
                            }
                        }
                    }
                } else if (this.plugin.getConfig().getBoolean("junk.particles")) {
                    this.plugin.getUtils().getJunkTravellers(this.loc).forEach(e -> {
                        if (e instanceof Player) {
                            Player p = (Player)e;
                            TARDISParticles.sendVortexParticles(this.effectsLoc, p);
                        }
                    });
                }
            } else {
                this.plugin.getTrackerKeeper().getMaterialising().remove(this.bd.getTardisID());
                this.plugin.getTrackerKeeper().getInVortex().remove(this.bd.getTardisID());
                this.plugin.getServer().getScheduler().cancelTask(this.fryTask);
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
                this.plugin.getGeneralKeeper().setJunkTravelling(false);
                this.plugin.getGeneralKeeper().getJunkTravellers().clear();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", this.bd.getTardisID());
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", this.loc.getWorld().getName());
                set.put("x", this.loc.getBlockX());
                set.put("y", this.sy);
                set.put("z", this.loc.getBlockZ());
                this.plugin.getQueryFactory().doUpdate("current", set, where);
                new TARDISJunkReturnPersiter(this.plugin).setJunkTime();
            }
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

