/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class TARDISPortalPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;
    private int counta = 0;

    public TARDISPortalPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "portals (portal, teleport, direction, tardis_id, abandoned) VALUES (?,?,?,?,?)");
            for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
                TARDISTeleportLocation ttpl = map.getValue();
                this.ps.setString(1, map.getKey().toString());
                this.ps.setString(2, ttpl.getLocation().toString());
                this.ps.setString(3, ttpl.getDirection().toString());
                this.ps.setInt(4, ttpl.getTardisId());
                this.ps.setInt(5, ttpl.isAbandoned() ? 1 : 0);
                if (ttpl.isAbandoned()) {
                    this.counta += this.ps.executeUpdate();
                    continue;
                }
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " portals.");
            }
            if (this.counta > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.counta + " abandoned portals.");
            }
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "movers (uuid) VALUES (?)");
            for (UUID uuid : this.plugin.getTrackerKeeper().getMovers()) {
                this.ps.setString(1, uuid.toString());
                this.ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for portals table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing portals statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "portals");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    String p = this.rs.getString("portal");
                    String t = this.rs.getString("teleport");
                    if (p.contains("null") || t.contains("null")) continue;
                    Location portal = TARDISStaticLocationGetters.getLocationFromBukkitString(p);
                    Location teleport = TARDISStaticLocationGetters.getLocationFromBukkitString(t);
                    if (portal == null || teleport == null) continue;
                    COMPASS direction = COMPASS.valueOf(this.rs.getString("direction"));
                    TARDISTeleportLocation ttpl = new TARDISTeleportLocation();
                    ttpl.setLocation(teleport);
                    ttpl.setDirection(direction);
                    ttpl.setTardisId(this.rs.getInt("tardis_id"));
                    boolean abandoned = this.rs.getBoolean("abandoned");
                    ttpl.setAbandoned(abandoned);
                    this.plugin.getTrackerKeeper().getPortals().put(portal, ttpl);
                    if (abandoned) {
                        ++this.counta;
                        continue;
                    }
                    ++this.count;
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " portals.");
            }
            if (this.counta > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.counta + " abandoned portals.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "portals");
            this.ps.executeUpdate();
            this.ps = this.connection.prepareStatement("SELECT uuid FROM " + this.prefix + "movers");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    this.plugin.getTrackerKeeper().getMovers().add(UUID.fromString(this.rs.getString("uuid")));
                }
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "movers");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for portals table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing portals statement or resultset: " + ex.getMessage());
            }
        }
    }
}

