/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISShowShapedRecipeInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final ShapedRecipe recipe;
    private final Inventory inventory;
    private final String str;

    public TARDISShowShapedRecipeInventory(TARDIS plugin, ShapedRecipe recipe, String str) {
        this.plugin = plugin;
        this.recipe = recipe;
        this.str = str;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)(str + " recipe"), (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getRecipeItems());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getRecipeItems() {
        String r;
        ItemStack[] stacks = new ItemStack[27];
        String[] recipeShape = this.recipe.getShape();
        Map ingredientMap = this.recipe.getChoiceMap();
        int glowstoneCount = 0;
        for (int j = 0; j < recipeShape.length; ++j) {
            for (int k = 0; k < recipeShape[j].length(); ++k) {
                ItemStack item = null;
                RecipeChoice choice = (RecipeChoice)ingredientMap.get(Character.valueOf(recipeShape[j].toCharArray()[k]));
                if (choice instanceof RecipeChoice.ExactChoice) {
                    RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
                    item = exact.getItemStack();
                } else if (choice instanceof RecipeChoice.MaterialChoice) {
                    RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)choice;
                    item = mat.getItemStack();
                }
                if (item == null) continue;
                ItemMeta im = item.getItemMeta();
                if (item.getType().equals((Object)Material.GLOWSTONE_DUST) && !this.str.endsWith("Tie")) {
                    String dn = this.getDisplayName(this.str, glowstoneCount);
                    im.displayName((Component)ComponentUtils.toWhite(dn));
                    ++glowstoneCount;
                }
                if (this.str.endsWith("TARDIS Remote Key")) {
                    Material material;
                    try {
                        material = Material.valueOf((String)this.plugin.getConfig().getString("preferences.key"));
                    }
                    catch (IllegalArgumentException e) {
                        material = Material.GOLD_NUGGET;
                    }
                    if (item.getType().equals((Object)material)) {
                        im.displayName((Component)ComponentUtils.toWhite("TARDIS Key"));
                    }
                }
                if (this.str.equals("Acid Battery") && item.getType().equals((Object)Material.WATER_BUCKET)) {
                    im.displayName((Component)ComponentUtils.toWhite("Acid Bucket"));
                }
                if (this.str.equals("Rift Manipulator") && item.getType().equals((Object)Material.NETHER_BRICK)) {
                    im.displayName((Component)ComponentUtils.toWhite("Acid Battery"));
                }
                if (this.str.equals("Rust Plague Sword") && item.getType().equals((Object)Material.LAVA_BUCKET)) {
                    im.displayName((Component)ComponentUtils.toWhite("Rust Bucket"));
                }
                item.setItemMeta(im);
                stacks[j * 9 + k] = item;
            }
        }
        ItemStack result = this.recipe.getResult();
        ItemMeta im = result.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite(this.str));
        if (this.str.equals("TARDIS Invisibility Circuit")) {
            List lore = im.lore();
            TextComponent uses = this.plugin.getConfig().getString("circuits.uses.invisibility", "5").equals("0") || !this.plugin.getConfig().getBoolean("circuits.damage") ? Component.text((String)"unlimited", (TextColor)NamedTextColor.YELLOW) : Component.text((String)this.plugin.getConfig().getString("circuits.uses.invisibility", "5"), (TextColor)NamedTextColor.YELLOW);
            lore.set(1, uses);
            im.lore(lore);
        }
        if (this.str.equals("Blank Storage Disk") || this.str.equals("Save Storage Disk") || this.str.equals("Preset Storage Disk") || this.str.equals("Biome Storage Disk") || this.str.equals("Player Storage Disk") || this.str.equals("Authorised Control Disk")) {
            im.addItemFlags(ItemFlag.values());
            im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        }
        if (this.str.startsWith("Door")) {
            r = this.str.replace("Door ", "").toLowerCase(Locale.ROOT);
            if (r.equals("door")) {
                r = "tardis_door";
            }
            im.setItemModel(new NamespacedKey((Plugin)this.plugin, r + "_closed"));
        }
        if (this.str.startsWith("Time Rotor")) {
            r = this.str.replace("Time Rotor ", "").toLowerCase(Locale.ROOT);
            im.setItemModel(new NamespacedKey((Plugin)this.plugin, "time_rotor_" + r + "_off"));
        }
        result.setAmount(1);
        result.setItemMeta(im);
        stacks[17] = result;
        return stacks;
    }

    private String getDisplayName(String recipe, int quartzCount) {
        switch (recipe) {
            case "TARDIS Locator": {
                return "TARDIS Locator Circuit";
            }
            case "Stattenheim Remote": {
                return "TARDIS Stattenheim Circuit";
            }
            case "TARDIS Chameleon Circuit": 
            case "TARDIS Remote Key": {
                return "TARDIS Materialisation Circuit";
            }
            case "TARDIS Invisibility Circuit": 
            case "Perception Filter": {
                return "Perception Circuit";
            }
            case "Sonic Screwdriver": 
            case "Server Admin Circuit": 
            case "Sonic Dock": {
                return "Sonic Oscillator";
            }
            case "Fob Watch": 
            case "Preset Storage Disk": 
            case "TARDIS Television": {
                return "TARDIS Chameleon Circuit";
            }
            case "TARDIS Biome Reader": 
            case "Emerald Upgrade": {
                return "Emerald Environment Circuit";
            }
            case "Rift Manipulator": {
                return "Rift Circuit";
            }
            case "Admin Upgrade": {
                return "Server Admin Circuit";
            }
            case "Bio-scanner Upgrade": {
                return "Bio-scanner Circuit";
            }
            case "Redstone Upgrade": {
                return "Redstone Activator Circuit";
            }
            case "Diamond Upgrade": {
                return "Diamond Disruptor Circuit";
            }
            case "Painter Upgrade": {
                return "Painter Circuit";
            }
            case "Ignite Upgrade": {
                return "Ignite Circuit";
            }
            case "Pickup Arrows Upgrade": {
                return "Pickup Arrows Circuit";
            }
            case "Knockback Upgrade": {
                return "Knockback Circuit";
            }
            case "Brush Upgrade": {
                return "Brush Circuit";
            }
            case "Conversion Upgrade": {
                return "Conversion Circuit";
            }
        }
        if (quartzCount == 0) {
            return "TARDIS Locator Circuit";
        }
        return "TARDIS Materialisation Circuit";
    }
}

