/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import me.eccentric_nz.TARDIS.TARDIS;

public class TARDISNumberParsers {
    public static int parseInt(String i) {
        int num = 0;
        try {
            num = Integer.parseInt(i);
        }
        catch (NumberFormatException n) {
            TARDIS.plugin.debug("Could not convert to int, the string was: " + i);
        }
        return num;
    }

    public static float parseFloat(String i) {
        float num = 0.0f;
        try {
            num = Float.parseFloat(i);
        }
        catch (NumberFormatException n) {
            TARDIS.plugin.debug("Could not convert to float, the string was: " + i);
        }
        return num;
    }

    public static double parseDouble(String i) {
        double num = 0.0;
        try {
            num = Double.parseDouble(i);
        }
        catch (NumberFormatException n) {
            TARDIS.plugin.debug("Could not convert to double, the string was: " + i);
        }
        return num;
    }

    public static long parseLong(String i) {
        long num = 0L;
        try {
            num = Long.parseLong(i);
        }
        catch (NumberFormatException n) {
            TARDIS.plugin.debug("Could not convert to double, the string was: " + i);
        }
        return num;
    }

    public static int roundUp(int num, int divisor) {
        return (num + divisor - 1) / divisor;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (str.isEmpty()) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] != 'e' && chars[i] != 'E') {
                if (chars[i] != '+' && chars[i] != '-') {
                    return false;
                }
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            if (hasExp) {
                return false;
            }
            if (!foundDigit) {
                return false;
            }
            hasExp = true;
            allowSigns = true;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] != 'e' && chars[i] != 'E') {
                if (chars[i] == '.') {
                    return !hasDecPoint && !hasExp && foundDigit;
                }
                if (allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F') {
                    if (chars[i] != 'l' && chars[i] != 'L') {
                        return false;
                    }
                    return foundDigit && !hasExp;
                }
                return foundDigit;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isSimpleNumber(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

