/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen;

import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischunkgenerator.worldgen.biomeproviders.FlatBiomeProvider;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class FlatGenerator
extends ChunkGenerator {
    private final Material bottom;
    private final Material rock;
    private final Material middle;
    private final Material surface;

    public FlatGenerator(TARDIS plugin) {
        this.bottom = Material.valueOf((String)plugin.getGeneratorConfig().getString("flat.bottom"));
        this.rock = Material.valueOf((String)plugin.getGeneratorConfig().getString("flat.rock"));
        this.middle = Material.valueOf((String)plugin.getGeneratorConfig().getString("flat.middle"));
        this.surface = Material.valueOf((String)plugin.getGeneratorConfig().getString("flat.surface"));
    }

    public void generateSurface(WorldInfo worldInfo, Random random, int x, int z, ChunkGenerator.ChunkData chunkData) {
        if (chunkData.getMinHeight() == worldInfo.getMinHeight()) {
            for (int bx = 0; bx < 16; ++bx) {
                for (int bz = 0; bz < 16; ++bz) {
                    for (int by = 1; by < 65; ++by) {
                        if (by < 60) {
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.rock);
                            continue;
                        }
                        if (by < 64) {
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.middle);
                            continue;
                        }
                        chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.surface);
                    }
                }
            }
        }
    }

    public void generateBedrock(WorldInfo worldInfo, Random random, int x, int z, ChunkGenerator.ChunkData chunkData) {
        if (chunkData.getMinHeight() == worldInfo.getMinHeight()) {
            for (int bx = 0; bx < 16; ++bx) {
                for (int bz = 0; bz < 16; ++bz) {
                    chunkData.setBlock(bx, chunkData.getMinHeight(), bz, this.bottom);
                }
            }
        }
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return new FlatBiomeProvider();
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, -60.0, 0.0);
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }
}

