/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.silurians;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.travel.Check;
import me.eccentric_nz.TARDIS.travel.TARDISCaveFinder;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public class CaveFinder {
    private static final List<BlockFace> directions = new ArrayList<BlockFace>(List.of(BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH));

    public static Location searchSpawnPoint(Location playerLocation, boolean checkSlimeChunk) {
        World w = playerLocation.getWorld();
        int startx = playerLocation.getBlockX();
        int starty = playerLocation.getBlockY();
        int startz = playerLocation.getBlockZ();
        if (TARDISCaveFinder.worldCheck(w)) {
            int plusx = startx + 24;
            int plusz = startz + 24;
            int minusx = startx - 24;
            int minusz = startz - 24;
            int step = 4;
            Collections.shuffle(directions);
            block5: for (int i = 0; i < 4; ++i) {
                switch (directions.get(i)) {
                    case EAST: {
                        Check chk;
                        for (int east = plusx; east > startx; east -= step) {
                            chk = CaveFinder.isThereRoom(w, east, startz, starty, checkSlimeChunk);
                            if (!chk.isSafe()) continue;
                            return new Location(w, (double)east, (double)chk.getY(), (double)startz);
                        }
                        continue block5;
                    }
                    case SOUTH: {
                        Check chk;
                        for (int south = plusz; south > startz; south -= step) {
                            chk = CaveFinder.isThereRoom(w, startx, south, starty, checkSlimeChunk);
                            if (!chk.isSafe()) continue;
                            return new Location(w, (double)startx, (double)chk.getY(), (double)south);
                        }
                        continue block5;
                    }
                    case WEST: {
                        Check chk;
                        for (int west = minusx; west < startx; west += step) {
                            chk = CaveFinder.isThereRoom(w, west, startz, starty, checkSlimeChunk);
                            if (!chk.isSafe()) continue;
                            return new Location(w, (double)west, (double)chk.getY(), (double)startz);
                        }
                        continue block5;
                    }
                    default: {
                        Check chk;
                        for (int north = minusz; north < startz; north += step) {
                            chk = CaveFinder.isThereRoom(w, startx, north, starty, checkSlimeChunk);
                            if (!chk.isSafe()) continue;
                            return new Location(w, (double)startx, (double)chk.getY(), (double)north);
                        }
                    }
                }
            }
        }
        return null;
    }

    private static Check isThereRoom(World w, int x, int z, int sy, boolean checkSlimeChunk) {
        Check ret = new Check();
        ret.setSafe(false);
        for (int y = sy + 8; y > sy - 8; --y) {
            int yy;
            if (!w.getBlockAt(x, y, z).getType().isAir() || (yy = TARDISCaveFinder.getLowestAirBlock(w, x, y, z)) > y - 2 || !Tag.BASE_STONE_OVERWORLD.isTagged((Keyed)w.getBlockAt(x - 1, yy - 1, z - 1).getType()) || !w.getBlockAt(x - 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x - 1, yy, z).getType().isAir() || !w.getBlockAt(x - 1, yy, z + 1).getType().isAir() || !w.getBlockAt(x, yy, z - 1).getType().isAir() || !w.getBlockAt(x, yy, z + 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z).getType().isAir() || !w.getBlockAt(x + 1, yy, z + 1).getType().isAir()) continue;
            ret.setSafe(!checkSlimeChunk || w.getBlockAt(x, yy, z).getChunk().isSlimeChunk());
            ret.setY(yy);
        }
        return ret;
    }
}

